/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort.light;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.pojo.workflow.form.LightGroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightGroupSortSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(LightGroupSortSelector.class);

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        if (!(processForm instanceof LightGroupResourceProcessForm)) {
            return false;
        }
        LightGroupResourceProcessForm lightGroupResourceProcessForm = (LightGroupResourceProcessForm)processForm;
        List streamInfos = lightGroupResourceProcessForm.getStreamInfos();
        if (CollectionUtils.isEmpty((Collection)streamInfos)) {
            log.warn(ErrorCodeEnum.STREAM_NOT_FOUND.getMessage());
            return false;
        }
        return true;
    }
}

