/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.MetaField;
import org.apache.inlong.manager.common.enums.FieldType;
import org.apache.inlong.manager.common.pojo.sink.SinkField;
import org.apache.inlong.manager.common.pojo.stream.StreamField;
import org.apache.inlong.sort.formats.common.ArrayFormatInfo;
import org.apache.inlong.sort.formats.common.BooleanFormatInfo;
import org.apache.inlong.sort.formats.common.ByteFormatInfo;
import org.apache.inlong.sort.formats.common.ByteTypeInfo;
import org.apache.inlong.sort.formats.common.DateFormatInfo;
import org.apache.inlong.sort.formats.common.DecimalFormatInfo;
import org.apache.inlong.sort.formats.common.DoubleFormatInfo;
import org.apache.inlong.sort.formats.common.FloatFormatInfo;
import org.apache.inlong.sort.formats.common.FormatInfo;
import org.apache.inlong.sort.formats.common.IntFormatInfo;
import org.apache.inlong.sort.formats.common.LongFormatInfo;
import org.apache.inlong.sort.formats.common.ShortFormatInfo;
import org.apache.inlong.sort.formats.common.StringFormatInfo;
import org.apache.inlong.sort.formats.common.TimeFormatInfo;
import org.apache.inlong.sort.formats.common.TimestampFormatInfo;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.MetaFieldInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(FieldInfoUtils.class);

    public static FieldInfo parseSinkFieldInfo(SinkField sinkField, String nodeId) {
        boolean isMetaField = sinkField.getIsMetaField() == 1;
        FieldInfo fieldInfo = FieldInfoUtils.getFieldInfo(sinkField.getFieldName(), sinkField.getFieldType(), isMetaField, sinkField.getMetaFieldName(), sinkField.getFieldFormat());
        fieldInfo.setNodeId(nodeId);
        return fieldInfo;
    }

    public static FieldInfo parseStreamFieldInfo(StreamField streamField, String nodeId) {
        boolean isMetaField = streamField.getIsMetaField() == 1;
        FieldInfo fieldInfo = FieldInfoUtils.getFieldInfo(streamField.getFieldName(), streamField.getFieldType(), isMetaField, streamField.getMetaFieldName(), streamField.getFieldFormat());
        fieldInfo.setNodeId(nodeId);
        return fieldInfo;
    }

    public static FieldInfo parseStreamField(StreamField streamField) {
        boolean isMetaField = streamField.getIsMetaField() == 1;
        FieldInfo fieldInfo = FieldInfoUtils.getFieldInfo(streamField.getFieldName(), streamField.getFieldType(), isMetaField, streamField.getMetaFieldName(), streamField.getFieldFormat());
        fieldInfo.setNodeId(streamField.getOriginNodeName());
        return fieldInfo;
    }

    private static FieldInfo getFieldInfo(String fieldName, String fieldType, boolean isMetaField, String metaFieldName, String format) {
        if (isMetaField) {
            return new MetaFieldInfo(fieldName, MetaField.forName((String)metaFieldName));
        }
        return new FieldInfo(fieldName, FieldInfoUtils.convertFieldFormat(fieldType, format));
    }

    public static FormatInfo convertFieldFormat(String type) {
        return FieldInfoUtils.convertFieldFormat(type, null);
    }

    public static FormatInfo convertFieldFormat(String type, String format) {
        BooleanFormatInfo formatInfo;
        FieldType fieldType = FieldType.forName((String)type);
        switch (fieldType) {
            case BOOLEAN: {
                formatInfo = new BooleanFormatInfo();
                break;
            }
            case INT8: 
            case TINYINT: 
            case BYTE: {
                formatInfo = new ByteFormatInfo();
                break;
            }
            case INT16: 
            case SMALLINT: 
            case SHORT: {
                formatInfo = new ShortFormatInfo();
                break;
            }
            case INT32: 
            case INT: {
                formatInfo = new IntFormatInfo();
                break;
            }
            case INT64: 
            case BIGINT: 
            case LONG: {
                formatInfo = new LongFormatInfo();
                break;
            }
            case FLOAT32: 
            case FLOAT: {
                formatInfo = new FloatFormatInfo();
                break;
            }
            case FLOAT64: 
            case DOUBLE: {
                formatInfo = new DoubleFormatInfo();
                break;
            }
            case DECIMAL: {
                formatInfo = new DecimalFormatInfo();
                break;
            }
            case DATE: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new DateFormatInfo(FieldInfoUtils.convertToSortFormat(format));
                    break;
                }
                formatInfo = new DateFormatInfo();
                break;
            }
            case DATETIME: 
            case TIME: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new TimeFormatInfo(FieldInfoUtils.convertToSortFormat(format));
                    break;
                }
                formatInfo = new TimeFormatInfo();
                break;
            }
            case TIMESTAMP: {
                if (StringUtils.isNotBlank((CharSequence)format)) {
                    formatInfo = new TimestampFormatInfo(FieldInfoUtils.convertToSortFormat(format));
                    break;
                }
                formatInfo = new TimestampFormatInfo();
                break;
            }
            case BINARY: 
            case FIXED: {
                formatInfo = new ArrayFormatInfo(ByteTypeInfo::new);
                break;
            }
            default: {
                formatInfo = new StringFormatInfo();
            }
        }
        return formatInfo;
    }

    private static String convertToSortFormat(String format) {
        String sortFormat = format;
        switch (format) {
            case "MICROSECONDS": {
                sortFormat = "MICROS";
                break;
            }
            case "MILLISECONDS": {
                sortFormat = "MILLIS";
                break;
            }
            case "SECONDS": {
                sortFormat = "SECONDS";
                break;
            }
        }
        return sortFormat;
    }
}

