/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SinkType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.sink.SinkField;
import org.apache.inlong.manager.common.pojo.sink.StreamSink;
import org.apache.inlong.manager.common.pojo.sink.ck.ClickHouseSink;
import org.apache.inlong.manager.common.pojo.sink.es.ElasticsearchSink;
import org.apache.inlong.manager.common.pojo.sink.greenplum.GreenplumSink;
import org.apache.inlong.manager.common.pojo.sink.hbase.HBaseSink;
import org.apache.inlong.manager.common.pojo.sink.hdfs.HdfsSink;
import org.apache.inlong.manager.common.pojo.sink.hive.HivePartitionField;
import org.apache.inlong.manager.common.pojo.sink.hive.HiveSink;
import org.apache.inlong.manager.common.pojo.sink.iceberg.IcebergSink;
import org.apache.inlong.manager.common.pojo.sink.kafka.KafkaSink;
import org.apache.inlong.manager.common.pojo.sink.mysql.MySQLSink;
import org.apache.inlong.manager.common.pojo.sink.postgres.PostgresSink;
import org.apache.inlong.manager.common.pojo.sink.sqlserver.SqlServerSink;
import org.apache.inlong.manager.service.sort.util.FieldInfoUtils;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.constant.IcebergConstant;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.AvroFormat;
import org.apache.inlong.sort.protocol.node.format.CanalJsonFormat;
import org.apache.inlong.sort.protocol.node.format.CsvFormat;
import org.apache.inlong.sort.protocol.node.format.DebeziumJsonFormat;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.format.JsonFormat;
import org.apache.inlong.sort.protocol.node.load.ClickHouseLoadNode;
import org.apache.inlong.sort.protocol.node.load.ElasticsearchLoadNode;
import org.apache.inlong.sort.protocol.node.load.FileSystemLoadNode;
import org.apache.inlong.sort.protocol.node.load.GreenplumLoadNode;
import org.apache.inlong.sort.protocol.node.load.HbaseLoadNode;
import org.apache.inlong.sort.protocol.node.load.HiveLoadNode;
import org.apache.inlong.sort.protocol.node.load.IcebergLoadNode;
import org.apache.inlong.sort.protocol.node.load.KafkaLoadNode;
import org.apache.inlong.sort.protocol.node.load.MySqlLoadNode;
import org.apache.inlong.sort.protocol.node.load.PostgresLoadNode;
import org.apache.inlong.sort.protocol.node.load.SqlServerLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;

public class LoadNodeUtils {
    public static List<LoadNode> createLoadNodes(List<StreamSink> streamSinks) {
        if (CollectionUtils.isEmpty(streamSinks)) {
            return Lists.newArrayList();
        }
        return streamSinks.stream().map(LoadNodeUtils::createLoadNode).collect(Collectors.toList());
    }

    public static LoadNode createLoadNode(StreamSink streamSink) {
        SinkType sinkType = SinkType.forType((String)streamSink.getSinkType());
        switch (sinkType) {
            case KAFKA: {
                return LoadNodeUtils.createLoadNode((KafkaSink)streamSink);
            }
            case HIVE: {
                return LoadNodeUtils.createLoadNode((HiveSink)streamSink);
            }
            case HBASE: {
                return LoadNodeUtils.createLoadNode((HBaseSink)streamSink);
            }
            case POSTGRES: {
                return LoadNodeUtils.createLoadNode((PostgresSink)streamSink);
            }
            case CLICKHOUSE: {
                return LoadNodeUtils.createLoadNode((ClickHouseSink)streamSink);
            }
            case ICEBERG: {
                return LoadNodeUtils.createLoadNode((IcebergSink)streamSink);
            }
            case SQLSERVER: {
                return LoadNodeUtils.createLoadNode((SqlServerSink)streamSink);
            }
            case ELASTICSEARCH: {
                return LoadNodeUtils.createLoadNode((ElasticsearchSink)streamSink);
            }
            case HDFS: {
                return LoadNodeUtils.createLoadNode((HdfsSink)streamSink);
            }
            case GREENPLUM: {
                return LoadNodeUtils.createLoadNode((GreenplumSink)streamSink);
            }
            case MYSQL: {
                return LoadNodeUtils.createLoadNode((MySQLSink)streamSink);
            }
        }
        throw new BusinessException(String.format("Unsupported sinkType=%s to create load node", sinkType));
    }

    public static KafkaLoadNode createLoadNode(KafkaSink kafkaSink) {
        CsvFormat format;
        String id = kafkaSink.getSinkName();
        String name = kafkaSink.getSinkName();
        List fieldList = kafkaSink.getSinkFieldList();
        List fieldInfos = fieldList.stream().map(field -> FieldInfoUtils.parseSinkFieldInfo(field, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(fieldList, name);
        Map<String, String> properties = kafkaSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        Integer sinkParallelism = null;
        if (StringUtils.isNotEmpty((CharSequence)kafkaSink.getPartitionNum())) {
            sinkParallelism = Integer.parseInt(kafkaSink.getPartitionNum());
        }
        DataTypeEnum dataType = DataTypeEnum.forName((String)kafkaSink.getSerializationType());
        switch (dataType) {
            case CSV: {
                format = new CsvFormat();
                break;
            }
            case AVRO: {
                format = new AvroFormat();
                break;
            }
            case JSON: {
                format = new JsonFormat();
                break;
            }
            case CANAL: {
                format = new CanalJsonFormat();
                break;
            }
            case DEBEZIUM_JSON: {
                format = new DebeziumJsonFormat();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported dataType=%s for Kafka", dataType));
            }
        }
        return new KafkaLoadNode(id, name, fieldInfos, fieldRelations, (List)Lists.newArrayList(), null, kafkaSink.getTopicName(), kafkaSink.getBootstrapServers(), (Format)format, sinkParallelism, properties, kafkaSink.getPrimaryKey());
    }

    public static HiveLoadNode createLoadNode(HiveSink hiveSink) {
        String id = hiveSink.getSinkName();
        String name = hiveSink.getSinkName();
        List fieldList = hiveSink.getSinkFieldList();
        List fields = fieldList.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(fieldList, name);
        Map<String, String> properties = hiveSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        List<Object> partitionFields = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)hiveSink.getPartitionFieldList())) {
            partitionFields = hiveSink.getPartitionFieldList().stream().map(partitionField -> new FieldInfo(partitionField.getFieldName(), name, FieldInfoUtils.convertFieldFormat(partitionField.getFieldType(), partitionField.getFieldFormat()))).collect(Collectors.toList());
        }
        return new HiveLoadNode(id, name, fields, fieldRelations, (List)Lists.newArrayList(), null, null, properties, null, hiveSink.getDbName(), hiveSink.getTableName(), hiveSink.getHiveConfDir(), hiveSink.getHiveVersion(), null, (List)partitionFields);
    }

    public static HbaseLoadNode createLoadNode(HBaseSink hbaseSink) {
        String id = hbaseSink.getSinkName();
        String name = hbaseSink.getSinkName();
        List fieldList = hbaseSink.getSinkFieldList();
        List fields = fieldList.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(fieldList, name);
        Map<String, String> properties = hbaseSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        return new HbaseLoadNode(id, name, fields, fieldRelations, (List)Lists.newArrayList(), null, null, properties, hbaseSink.getTableName(), hbaseSink.getNamespace(), hbaseSink.getZkQuorum(), hbaseSink.getRowKey(), hbaseSink.getBufferFlushMaxSize(), hbaseSink.getZkNodeParent(), hbaseSink.getBufferFlushMaxRows(), hbaseSink.getBufferFlushInterval());
    }

    public static PostgresLoadNode createLoadNode(PostgresSink postgresSink) {
        List fieldList = postgresSink.getSinkFieldList();
        String name = postgresSink.getSinkName();
        List fields = fieldList.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(fieldList, name);
        return new PostgresLoadNode(name, name, fields, fieldRelations, null, null, Integer.valueOf(1), null, postgresSink.getJdbcUrl(), postgresSink.getUsername(), postgresSink.getPassword(), postgresSink.getDbName() + "." + postgresSink.getTableName(), postgresSink.getPrimaryKey());
    }

    public static ClickHouseLoadNode createLoadNode(ClickHouseSink ckSink) {
        List sinkFields = ckSink.getSinkFieldList();
        String name = ckSink.getSinkName();
        List fields = sinkFields.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(sinkFields, name);
        return new ClickHouseLoadNode(name, name, fields, fieldRelations, null, null, Integer.valueOf(1), null, ckSink.getTableName(), ckSink.getJdbcUrl() + "/" + ckSink.getDbName(), ckSink.getUsername(), ckSink.getPassword());
    }

    public static IcebergLoadNode createLoadNode(IcebergSink icebergSink) {
        String id = icebergSink.getSinkName();
        String name = icebergSink.getSinkName();
        IcebergConstant.CatalogType catalogType = IcebergConstant.CatalogType.forName((String)icebergSink.getCatalogType());
        List sinkFields = icebergSink.getSinkFieldList();
        List fields = sinkFields.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelationShips = LoadNodeUtils.parseSinkFields(sinkFields, name);
        Map<String, String> properties = icebergSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        return new IcebergLoadNode(id, name, fields, fieldRelationShips, null, null, Integer.valueOf(1), properties, icebergSink.getDbName(), icebergSink.getTableName(), icebergSink.getPrimaryKey(), catalogType, icebergSink.getCatalogUri(), icebergSink.getWarehouse());
    }

    public static SqlServerLoadNode createLoadNode(SqlServerSink sqlServerSink) {
        String id = sqlServerSink.getSinkName();
        String name = sqlServerSink.getSinkName();
        List fieldList = sqlServerSink.getSinkFieldList();
        List fields = fieldList.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(fieldList, name);
        Map<String, String> properties = sqlServerSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        return new SqlServerLoadNode(id, name, fields, fieldRelations, null, null, null, properties, sqlServerSink.getJdbcUrl(), sqlServerSink.getUsername(), sqlServerSink.getPassword(), sqlServerSink.getSchemaName(), sqlServerSink.getTableName(), sqlServerSink.getPrimaryKey());
    }

    public static ElasticsearchLoadNode createLoadNode(ElasticsearchSink elasticsearchSink) {
        String id = elasticsearchSink.getSinkName();
        String name = elasticsearchSink.getSinkName();
        List fieldList = elasticsearchSink.getSinkFieldList();
        List fields = fieldList.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(fieldList, name);
        Map<String, String> properties = elasticsearchSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        return new ElasticsearchLoadNode(id, name, fields, fieldRelations, null, null, null, properties, elasticsearchSink.getIndexName(), elasticsearchSink.getHost(), elasticsearchSink.getUsername(), elasticsearchSink.getPassword(), elasticsearchSink.getDocumentType(), elasticsearchSink.getPrimaryKey(), elasticsearchSink.getVersion().intValue());
    }

    public static FileSystemLoadNode createLoadNode(HdfsSink hdfsSink) {
        String id = hdfsSink.getSinkName();
        String name = hdfsSink.getSinkName();
        List fieldList = hdfsSink.getSinkFieldList();
        List fields = fieldList.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(fieldList, name);
        Map<String, String> properties = hdfsSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        List<Object> partitionFields = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)hdfsSink.getPartitionFieldList())) {
            partitionFields = hdfsSink.getPartitionFieldList().stream().map(partitionField -> new FieldInfo(partitionField.getFieldName(), name, FieldInfoUtils.convertFieldFormat(partitionField.getFieldType(), partitionField.getFieldFormat()))).collect(Collectors.toList());
        }
        return new FileSystemLoadNode(id, name, fields, fieldRelations, (List)Lists.newArrayList(), hdfsSink.getDataPath(), hdfsSink.getFileFormat(), null, properties, (List)partitionFields, hdfsSink.getServerTimeZone());
    }

    public static GreenplumLoadNode createLoadNode(GreenplumSink greenplumSink) {
        String id = greenplumSink.getSinkName();
        String name = greenplumSink.getSinkName();
        List fieldList = greenplumSink.getSinkFieldList();
        List fields = fieldList.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(fieldList, name);
        Map<String, String> properties = greenplumSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        return new GreenplumLoadNode(id, name, fields, fieldRelations, null, null, Integer.valueOf(1), properties, greenplumSink.getJdbcUrl(), greenplumSink.getUsername(), greenplumSink.getPassword(), greenplumSink.getTableName(), greenplumSink.getPrimaryKey());
    }

    public static MySqlLoadNode createLoadNode(MySQLSink mysqlSink) {
        String id = mysqlSink.getSinkName();
        String name = mysqlSink.getSinkName();
        List fieldList = mysqlSink.getSinkFieldList();
        List fields = fieldList.stream().map(sinkField -> FieldInfoUtils.parseSinkFieldInfo(sinkField, name)).collect(Collectors.toList());
        List<FieldRelation> fieldRelations = LoadNodeUtils.parseSinkFields(fieldList, name);
        Map<String, String> properties = mysqlSink.getProperties().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
        return new MySqlLoadNode(id, name, fields, fieldRelations, (List)Lists.newArrayList(), null, null, properties, mysqlSink.getJdbcUrl(), mysqlSink.getUsername(), mysqlSink.getPassword(), mysqlSink.getTableName(), mysqlSink.getPrimaryKey());
    }

    public static List<FieldRelation> parseSinkFields(List<SinkField> fieldList, String sinkName) {
        if (CollectionUtils.isEmpty(fieldList)) {
            return Lists.newArrayList();
        }
        return fieldList.stream().filter(sinkField -> StringUtils.isNotEmpty((CharSequence)sinkField.getSourceFieldName())).map(field -> {
            String fieldName = field.getFieldName();
            String fieldType = field.getFieldType();
            String fieldFormat = field.getFieldFormat();
            FieldInfo sinkField = new FieldInfo(fieldName, sinkName, FieldInfoUtils.convertFieldFormat(fieldType, fieldFormat));
            String sourceFieldName = field.getSourceFieldName();
            String sourceFieldType = field.getSourceFieldType();
            FieldInfo sourceField = new FieldInfo(sourceFieldName, sinkName, FieldInfoUtils.convertFieldFormat(sourceFieldType));
            return new FieldRelation((FunctionParam)sourceField, sinkField);
        }).collect(Collectors.toList());
    }

    public static void checkPartitionField(List<SinkField> fieldList, List<HivePartitionField> partitionList) {
        if (CollectionUtils.isEmpty(partitionList)) {
            return;
        }
        if (CollectionUtils.isEmpty(fieldList)) {
            throw new BusinessException(ErrorCodeEnum.SINK_FIELD_LIST_IS_EMPTY);
        }
        HashMap sinkFieldMap = new HashMap(fieldList.size());
        fieldList.forEach(field -> sinkFieldMap.put(field.getFieldName(), field));
        for (HivePartitionField partitionField : partitionList) {
            String fieldName = partitionField.getFieldName();
            if (StringUtils.isBlank((CharSequence)fieldName)) {
                throw new BusinessException(ErrorCodeEnum.PARTITION_FIELD_NAME_IS_EMPTY);
            }
            SinkField sinkField = (SinkField)sinkFieldMap.get(fieldName);
            if (sinkField == null) {
                throw new BusinessException(String.format(ErrorCodeEnum.PARTITION_FIELD_NOT_FOUND.getMessage(), fieldName));
            }
            if (!StringUtils.isBlank((CharSequence)sinkField.getSourceFieldName())) continue;
            throw new BusinessException(String.format(ErrorCodeEnum.PARTITION_FIELD_NO_SOURCE_FIELD.getMessage(), fieldName));
        }
    }
}

