/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sort.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.common.pojo.stream.StreamField;
import org.apache.inlong.manager.common.pojo.transform.TransformDefinition;
import org.apache.inlong.manager.common.pojo.transform.TransformResponse;
import org.apache.inlong.manager.common.pojo.transform.deduplication.DeDuplicationDefinition;
import org.apache.inlong.manager.common.util.StreamParseUtils;
import org.apache.inlong.manager.service.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.service.sort.util.FieldRelationUtils;
import org.apache.inlong.manager.service.sort.util.FilterFunctionUtils;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.transform.DistinctNode;
import org.apache.inlong.sort.protocol.node.transform.TransformNode;
import org.apache.inlong.sort.protocol.transformation.OrderDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformNodeUtils {
    private static final Logger log = LoggerFactory.getLogger(TransformNodeUtils.class);

    public static List<TransformNode> createTransformNodes(List<TransformResponse> transformResponses) {
        if (CollectionUtils.isEmpty(transformResponses)) {
            return Lists.newArrayList();
        }
        return transformResponses.stream().map(TransformNodeUtils::createTransformNode).collect(Collectors.toList());
    }

    public static TransformNode createTransformNode(TransformResponse transformResponse) {
        TransformType transformType = TransformType.forType((String)transformResponse.getTransformType());
        if (transformType == TransformType.DE_DUPLICATION) {
            TransformDefinition transformDefinition = StreamParseUtils.parseTransformDefinition((String)transformResponse.getTransformDefinition(), (TransformType)transformType);
            return TransformNodeUtils.createDistinctNode((DeDuplicationDefinition)transformDefinition, transformResponse);
        }
        return TransformNodeUtils.createNormalTransformNode(transformResponse);
    }

    public static DistinctNode createDistinctNode(DeDuplicationDefinition deDuplicationDefinition, TransformResponse transformResponse) {
        OrderDirection orderDirection;
        List streamFields = deDuplicationDefinition.getDupFields();
        List distinctFields = streamFields.stream().map(FieldInfoUtils::parseStreamField).collect(Collectors.toList());
        StreamField timingField = deDuplicationDefinition.getTimingField();
        FieldInfo orderField = FieldInfoUtils.parseStreamField(timingField);
        DeDuplicationDefinition.DeDuplicationStrategy deDuplicationStrategy = deDuplicationDefinition.getDeDuplicationStrategy();
        switch (deDuplicationStrategy) {
            case RESERVE_LAST: {
                orderDirection = OrderDirection.DESC;
                break;
            }
            case RESERVE_FIRST: {
                orderDirection = OrderDirection.ASC;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported deduplication strategy=%s for inlong", deDuplicationStrategy));
            }
        }
        TransformNode transformNode = TransformNodeUtils.createNormalTransformNode(transformResponse);
        return new DistinctNode(transformNode.getId(), transformNode.getName(), transformNode.getFields(), transformNode.getFieldRelations(), transformNode.getFilters(), transformNode.getFilterStrategy(), distinctFields, orderField, orderDirection);
    }

    public static TransformNode createNormalTransformNode(TransformResponse transformResponse) {
        TransformNode transformNode = new TransformNode();
        transformNode.setId(transformResponse.getTransformName());
        transformNode.setName(transformResponse.getTransformName());
        List fieldInfos = transformResponse.getFieldList().stream().map(FieldInfoUtils::parseStreamField).collect(Collectors.toList());
        transformNode.setFields(fieldInfos);
        transformNode.setFieldRelations(FieldRelationUtils.createFieldRelations(transformResponse));
        transformNode.setFilters(FilterFunctionUtils.createFilterFunctions(transformResponse));
        transformNode.setFilterStrategy(FilterFunctionUtils.parseFilterStrategy(transformResponse));
        return transformNode;
    }
}

