/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GlobalConstants;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.stream.StreamField;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.dao.entity.StreamSourceFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceFieldEntityMapper;
import org.apache.inlong.manager.service.source.StreamSourceOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractSourceOperation
implements StreamSourceOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSourceOperation.class);
    @Autowired
    protected StreamSourceEntityMapper sourceMapper;
    @Autowired
    protected StreamSourceFieldEntityMapper sourceFieldMapper;

    protected abstract void setTargetEntity(SourceRequest var1, StreamSourceEntity var2);

    protected abstract String getSourceType();

    protected abstract StreamSource getSource();

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(SourceRequest request, Integer groupStatus, String operator) {
        String sourceName;
        String streamId;
        String groupId = request.getInlongGroupId();
        List existList = this.sourceMapper.selectByRelatedId(groupId, streamId = request.getInlongStreamId(), sourceName = request.getSourceName());
        if (CollectionUtils.isNotEmpty((Collection)existList)) {
            String err = "source name=%s already exists with groupId=%s streamId=%s";
            throw new BusinessException(String.format(err, sourceName, groupId, streamId));
        }
        StreamSourceEntity entity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        entity.setVersion(Integer.valueOf(1));
        if (GroupStatus.forCode((int)groupStatus).equals((Object)GroupStatus.CONFIG_SUCCESSFUL)) {
            entity.setStatus(SourceStatus.TO_BE_ISSUED_ADD.getCode());
        } else {
            entity.setStatus(SourceStatus.SOURCE_NEW.getCode());
        }
        entity.setCreator(operator);
        entity.setModifier(operator);
        Date now = new Date();
        entity.setCreateTime(now);
        entity.setModifyTime(now);
        entity.setIsDeleted(GlobalConstants.UN_DELETED);
        this.setTargetEntity(request, entity);
        this.sourceMapper.insert(entity);
        this.saveFieldOpt(entity, request.getFieldList());
        return entity.getId();
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, propagation=Propagation.NOT_SUPPORTED)
    public StreamSource getByEntity(@NotNull StreamSourceEntity entity) {
        Preconditions.checkNotNull((Object)entity, (String)ErrorCodeEnum.SOURCE_INFO_NOT_FOUND.getMessage());
        String existType = entity.getSourceType();
        Preconditions.checkTrue((boolean)this.getSourceType().equals(existType), (String)String.format(ErrorCodeEnum.SOURCE_TYPE_NOT_SAME.getMessage(), this.getSourceType(), existType));
        StreamSource source = this.getFromEntity(entity, this::getSource);
        List sourceFieldEntities = this.sourceFieldMapper.selectBySourceId(entity.getId());
        List fieldInfos = CommonBeanUtils.copyListProperties((List)sourceFieldEntities, StreamField::new);
        source.setFieldList(fieldInfos);
        return source;
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(SourceRequest request, Integer groupStatus, String operator) {
        StreamSourceEntity entity = this.sourceMapper.selectByIdForUpdate(request.getId());
        Preconditions.checkNotNull((Object)entity, (String)ErrorCodeEnum.SOURCE_INFO_NOT_FOUND.getMessage());
        if (!SourceStatus.ALLOWED_UPDATE.contains(entity.getStatus())) {
            throw new BusinessException(String.format("source=%s is not allowed to update, please wait until its changed to final status or stop / frozen / delete it firstly", entity));
        }
        if (!Objects.equals(entity.getSourceType(), request.getSourceType())) {
            throw new BusinessException(String.format("source type=%s cannot change to %s", entity.getSourceType(), request.getSourceType()));
        }
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        String sourceName = request.getSourceName();
        List sourceList = this.sourceMapper.selectByRelatedId(groupId, streamId, sourceName);
        for (StreamSourceEntity sourceEntity : sourceList) {
            Integer sourceId = sourceEntity.getId();
            if (Objects.equals(sourceId, request.getId())) continue;
            String err = "source name=%s already exists with the groupId=%s streamId=%s";
            throw new BusinessException(String.format(err, sourceName, groupId, streamId));
        }
        this.setTargetEntity(request, entity);
        entity.setVersion(Integer.valueOf(entity.getVersion() + 1));
        entity.setModifier(operator);
        entity.setModifyTime(new Date());
        this.sourceMapper.updateByPrimaryKeySelective(entity);
        this.updateFieldOpt(entity, request.getFieldList());
        LOGGER.info("success to update source of type={}", (Object)request.getSourceType());
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void stopOpt(SourceRequest request, String operator) {
        SourceStatus nextState;
        StreamSourceEntity existEntity = this.sourceMapper.selectByIdForUpdate(request.getId());
        SourceStatus curState = SourceStatus.forCode((int)existEntity.getStatus());
        if (!SourceStatus.isAllowedTransition((SourceStatus)curState, (SourceStatus)(nextState = SourceStatus.TO_BE_ISSUED_FROZEN))) {
            throw new BusinessException(String.format("source=%s is not allowed to stop", existEntity));
        }
        StreamSourceEntity curEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        curEntity.setVersion(Integer.valueOf(existEntity.getVersion() + 1));
        curEntity.setModifyTime(new Date());
        curEntity.setPreviousStatus(curState.getCode());
        curEntity.setStatus(nextState.getCode());
        this.sourceMapper.updateByPrimaryKeySelective(curEntity);
    }

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void restartOpt(SourceRequest request, String operator) {
        SourceStatus nextState;
        StreamSourceEntity existEntity = this.sourceMapper.selectByIdForUpdate(request.getId());
        SourceStatus curState = SourceStatus.forCode((int)existEntity.getStatus());
        if (!SourceStatus.isAllowedTransition((SourceStatus)curState, (SourceStatus)(nextState = SourceStatus.TO_BE_ISSUED_ACTIVE))) {
            throw new BusinessException(String.format("Source=%s is not allowed to restart", existEntity));
        }
        StreamSourceEntity curEntity = (StreamSourceEntity)CommonBeanUtils.copyProperties((Object)request, StreamSourceEntity::new);
        curEntity.setVersion(Integer.valueOf(existEntity.getVersion() + 1));
        curEntity.setModifyTime(new Date());
        curEntity.setPreviousStatus(curState.getCode());
        curEntity.setStatus(nextState.getCode());
        this.sourceMapper.updateByPrimaryKeySelective(curEntity);
    }

    private void updateFieldOpt(StreamSourceEntity entity, List<StreamField> fieldInfos) {
        Integer sourceId = entity.getId();
        if (CollectionUtils.isEmpty(fieldInfos)) {
            return;
        }
        this.sourceFieldMapper.deleteAll(sourceId);
        this.saveFieldOpt(entity, fieldInfos);
        LOGGER.info("success to update field");
    }

    private void saveFieldOpt(StreamSourceEntity entity, List<StreamField> fieldInfos) {
        LOGGER.info("begin to save source field={}", fieldInfos);
        if (CollectionUtils.isEmpty(fieldInfos)) {
            return;
        }
        int size = fieldInfos.size();
        ArrayList<StreamSourceFieldEntity> entityList = new ArrayList<StreamSourceFieldEntity>(size);
        String groupId = entity.getInlongGroupId();
        String streamId = entity.getInlongStreamId();
        String sourceType = entity.getSourceType();
        Integer sourceId = entity.getId();
        for (StreamField fieldInfo : fieldInfos) {
            StreamSourceFieldEntity fieldEntity = (StreamSourceFieldEntity)CommonBeanUtils.copyProperties((Object)fieldInfo, StreamSourceFieldEntity::new);
            if (StringUtils.isEmpty((CharSequence)fieldEntity.getFieldComment())) {
                fieldEntity.setFieldComment(fieldEntity.getFieldName());
            }
            fieldEntity.setInlongGroupId(groupId);
            fieldEntity.setInlongStreamId(streamId);
            fieldEntity.setSourceId(sourceId);
            fieldEntity.setSourceType(sourceType);
            fieldEntity.setIsDeleted(GlobalConstants.UN_DELETED);
            entityList.add(fieldEntity);
        }
        this.sourceFieldMapper.insertAll(entityList);
        LOGGER.info("success to save source fields");
    }
}

