/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.source.autopush;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.util.function.Supplier;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.SourceType;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.pojo.source.SourceListResponse;
import org.apache.inlong.manager.common.pojo.source.SourceRequest;
import org.apache.inlong.manager.common.pojo.source.StreamSource;
import org.apache.inlong.manager.common.pojo.source.autopush.AutoPushSource;
import org.apache.inlong.manager.common.pojo.source.autopush.AutoPushSourceDTO;
import org.apache.inlong.manager.common.pojo.source.autopush.AutoPushSourceListResponse;
import org.apache.inlong.manager.common.pojo.source.autopush.AutoPushSourceRequest;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSourceEntity;
import org.apache.inlong.manager.service.source.AbstractSourceOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AutoPushSourceOperation
extends AbstractSourceOperation {
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public PageInfo<? extends SourceListResponse> getPageInfo(Page<StreamSourceEntity> entityPage) {
        if (CollectionUtils.isEmpty(entityPage)) {
            return new PageInfo();
        }
        return entityPage.toPageInfo(entity -> this.getFromEntity((StreamSourceEntity)entity, AutoPushSourceListResponse::new));
    }

    @Override
    protected void setTargetEntity(SourceRequest request, StreamSourceEntity targetEntity) {
        AutoPushSourceRequest sourceRequest = (AutoPushSourceRequest)request;
        CommonBeanUtils.copyProperties((Object)sourceRequest, (Object)targetEntity, (boolean)true);
        try {
            AutoPushSourceDTO dto = AutoPushSourceDTO.getFromRequest((AutoPushSourceRequest)sourceRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage());
        }
    }

    @Override
    protected String getSourceType() {
        return SourceType.AUTO_PUSH.getType();
    }

    @Override
    protected StreamSource getSource() {
        return new AutoPushSource();
    }

    @Override
    public Boolean accept(SourceType sourceType) {
        return SourceType.AUTO_PUSH == sourceType;
    }

    @Override
    public <T> T getFromEntity(StreamSourceEntity entity, Supplier<T> target) {
        T result = target.get();
        if (entity == null) {
            return result;
        }
        String existType = entity.getSourceType();
        Preconditions.checkTrue((boolean)this.getSourceType().equals(existType), (String)String.format(ErrorCodeEnum.SOURCE_TYPE_NOT_SAME.getMessage(), this.getSourceType(), existType));
        AutoPushSourceDTO dto = AutoPushSourceDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, result, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, result, (boolean)true);
        return result;
    }
}

