/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowNoRollbackException;
import org.apache.inlong.manager.common.pojo.workflow.EventLogQuery;
import org.apache.inlong.manager.common.pojo.workflow.ProcessCountQuery;
import org.apache.inlong.manager.common.pojo.workflow.ProcessCountResponse;
import org.apache.inlong.manager.common.pojo.workflow.ProcessDetailResponse;
import org.apache.inlong.manager.common.pojo.workflow.ProcessQuery;
import org.apache.inlong.manager.common.pojo.workflow.ProcessResponse;
import org.apache.inlong.manager.common.pojo.workflow.TaskCountQuery;
import org.apache.inlong.manager.common.pojo.workflow.TaskCountResponse;
import org.apache.inlong.manager.common.pojo.workflow.TaskExecuteLogQuery;
import org.apache.inlong.manager.common.pojo.workflow.TaskQuery;
import org.apache.inlong.manager.common.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.TaskForm;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowExecuteLog;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionService;
import org.apache.inlong.manager.workflow.core.ProcessService;
import org.apache.inlong.manager.workflow.core.TaskService;
import org.apache.inlong.manager.workflow.core.WorkflowQueryService;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.util.WorkflowBeanUtils;
import org.apache.inlong.manager.workflow.util.WorkflowFormParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class WorkflowServiceImpl
implements WorkflowService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    @Autowired
    private WorkflowQueryService queryService;
    @Autowired
    private ProcessDefinitionService processDefService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult start(ProcessName process, String applicant, ProcessForm form) {
        WorkflowContext context = this.processService.start(process.name(), applicant, form);
        return WorkflowBeanUtils.result((WorkflowContext)context);
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult cancel(Integer processId, String operator, String remark) {
        WorkflowContext context = this.processService.cancel(processId, operator, remark);
        return WorkflowBeanUtils.result((WorkflowContext)context);
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult approve(Integer taskId, String remark, TaskForm form, String operator) {
        WorkflowContext context = this.taskService.approve(taskId, remark, form, operator);
        return WorkflowBeanUtils.result((WorkflowContext)context);
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult reject(Integer taskId, String remark, String operator) {
        WorkflowContext context = this.taskService.reject(taskId, remark, operator);
        return WorkflowBeanUtils.result((WorkflowContext)context);
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult transfer(Integer taskId, String remark, List<String> to, String operator) {
        WorkflowContext context = this.taskService.transfer(taskId, remark, to, operator);
        return WorkflowBeanUtils.result((WorkflowContext)context);
    }

    @Override
    @Transactional(noRollbackFor={WorkflowNoRollbackException.class}, rollbackFor={Exception.class})
    public WorkflowResult complete(Integer taskId, String remark, String operator) {
        WorkflowContext context = this.taskService.complete(taskId, remark, operator);
        return WorkflowBeanUtils.result((WorkflowContext)context);
    }

    @Override
    public ProcessDetailResponse detail(Integer processId, Integer taskId, String operator) {
        return this.queryService.detail(processId, taskId, operator);
    }

    @Override
    public PageInfo<ProcessResponse> listProcess(ProcessQuery query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page result = (Page)this.queryService.listProcessEntity(query);
        PageInfo pageInfo = result.toPageInfo(entity -> {
            ProcessResponse response = WorkflowBeanUtils.fromProcessEntity((WorkflowProcessEntity)entity);
            if (query.getIncludeShowInList().booleanValue()) {
                response.setShowInList(this.getShowInList((WorkflowProcessEntity)entity));
            }
            return response;
        });
        pageInfo.setTotal(result.getTotal());
        if (query.getIncludeCurrentTask().booleanValue()) {
            TaskQuery taskQuery = TaskQuery.builder().type(UserTask.class.getSimpleName()).statusSet(Collections.singleton(TaskStatus.PENDING)).build();
            PageHelper.startPage((int)0, (int)100);
            pageInfo.getList().forEach(this.addCurrentTask(taskQuery));
        }
        return pageInfo;
    }

    @Override
    public PageInfo<TaskResponse> listTask(TaskQuery query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page result = (Page)this.queryService.listTaskEntity(query);
        PageInfo pageInfo = result.toPageInfo(WorkflowBeanUtils::fromTaskEntity);
        this.addShowInListForEachTask(pageInfo.getList());
        pageInfo.setTotal(result.getTotal());
        return pageInfo;
    }

    @Override
    public ProcessCountResponse countProcess(ProcessCountQuery query) {
        return this.queryService.countProcess(query);
    }

    @Override
    public TaskCountResponse countTask(TaskCountQuery query) {
        return this.queryService.countTask(query);
    }

    @Override
    public PageInfo<WorkflowExecuteLog> listTaskExecuteLogs(TaskExecuteLogQuery query) {
        Preconditions.checkNotNull((Object)query, (String)"task execute log query params cannot be null");
        String groupId = query.getInlongGroupId();
        List processNameList = query.getProcessNames();
        Preconditions.checkNotEmpty((String)groupId, (String)"inlong group id cannot be null");
        Preconditions.checkNotEmpty((Collection)processNameList, (String)"process name list cannot be null");
        ProcessQuery processRequest = new ProcessQuery();
        processRequest.setInlongGroupId(groupId);
        processRequest.setNameList(processNameList);
        processRequest.setHidden(Integer.valueOf(1));
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page entityPage = (Page)this.queryService.listProcessEntity(processRequest);
        PageInfo pageInfo = entityPage.toPageInfo(inst -> WorkflowExecuteLog.builder().processId(inst.getId()).processDisplayName(inst.getDisplayName()).status(inst.getStatus()).startTime(inst.getStartTime()).endTime(inst.getEndTime()).build());
        for (WorkflowExecuteLog executeLog : pageInfo.getList()) {
            TaskQuery taskQuery = new TaskQuery();
            taskQuery.setProcessId(executeLog.getProcessId());
            taskQuery.setType(taskQuery.getType());
            List<WorkflowExecuteLog.TaskExecutorLog> executorLogs = this.queryService.listTaskEntity(taskQuery).stream().map(WorkflowExecuteLog.TaskExecutorLog::buildFromTaskInst).collect(Collectors.toList());
            for (WorkflowExecuteLog.TaskExecutorLog taskExecutorLog : executorLogs) {
                EventLogQuery eventLogQuery = new EventLogQuery();
                eventLogQuery.setTaskId(taskExecutorLog.getTaskId());
                List<WorkflowExecuteLog.ListenerExecutorLog> logs = this.queryService.listEventLog(eventLogQuery).stream().map(WorkflowExecuteLog.ListenerExecutorLog::fromEventLog).collect(Collectors.toList());
                taskExecutorLog.setListenerExecutorLogs(logs);
            }
            executeLog.setTaskExecutorLogs(executorLogs);
        }
        LOGGER.info("success to page list task execute logs for " + query);
        pageInfo.setTotal(entityPage.getTotal());
        return pageInfo;
    }

    private List<WorkflowExecuteLog.TaskExecutorLog> getTaskExecutorLogs(Integer processId, String taskType) {
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setProcessId(processId);
        taskQuery.setType(taskType);
        return this.queryService.listTaskEntity(taskQuery).stream().map(WorkflowExecuteLog.TaskExecutorLog::buildFromTaskInst).collect(Collectors.toList());
    }

    private List<WorkflowExecuteLog.ListenerExecutorLog> getListenerExecutorLogs(WorkflowExecuteLog.TaskExecutorLog executorLog) {
        EventLogQuery query = EventLogQuery.builder().taskId(executorLog.getTaskId()).build();
        return this.queryService.listEventLog(query).stream().map(WorkflowExecuteLog.ListenerExecutorLog::fromEventLog).collect(Collectors.toList());
    }

    private Consumer<ProcessResponse> addCurrentTask(TaskQuery query) {
        return plv -> {
            query.setProcessId(plv.getId());
            plv.setCurrentTasks(this.listTask(query).getList());
        };
    }

    private Map<String, Object> getShowInList(WorkflowProcessEntity processEntity) {
        WorkflowProcess process = this.processDefService.getByName(processEntity.getName());
        if (process == null || process.getFormClass() == null) {
            return null;
        }
        try {
            ProcessForm processForm = WorkflowFormParserUtils.parseProcessForm((ObjectMapper)this.objectMapper, (String)processEntity.getFormData(), (WorkflowProcess)process);
            assert (processForm != null);
            return processForm.showInList();
        }
        catch (Exception e) {
            LOGGER.error("get showIn list err", (Throwable)e);
            return null;
        }
    }

    private void addShowInListForEachTask(List<TaskResponse> taskList) {
        if (CollectionUtils.isEmpty(taskList)) {
            return;
        }
        PageHelper.clearPage();
        List list = taskList.stream().map(TaskResponse::getProcessId).distinct().collect(Collectors.toList());
        ProcessQuery query = new ProcessQuery();
        query.setIdList(list);
        List processEntities = this.queryService.listProcessEntity(query);
        HashMap processShowInListMap = Maps.newHashMap();
        processEntities.forEach(entity -> processShowInListMap.put(entity.getId(), this.getShowInList((WorkflowProcessEntity)entity)));
        taskList.forEach(task -> task.setShowInList((Map)processShowInListMap.get(task.getProcessId())));
    }
}

