/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.consumption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.workflow.WorkflowApproverFilterContext;
import org.apache.inlong.manager.common.pojo.workflow.form.ConsumptionApproveForm;
import org.apache.inlong.manager.common.pojo.workflow.form.NewConsumptionProcessForm;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.consumption.NewConsumptionProcessDetailHandler;
import org.apache.inlong.manager.service.workflow.consumption.listener.ConsumptionCancelProcessListener;
import org.apache.inlong.manager.service.workflow.consumption.listener.ConsumptionCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.consumption.listener.ConsumptionPassTaskListener;
import org.apache.inlong.manager.service.workflow.consumption.listener.ConsumptionRejectProcessListener;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ProcessDetailHandler;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewConsumptionWorkflowDefinition
implements WorkflowDefinition {
    public static final String UT_ADMINT_NAME = "ut_admin";
    public static final String UT_GROUP_OWNER_NAME = "ut_biz_owner";
    @Autowired
    private ConsumptionCompleteProcessListener consumptionCompleteProcessListener;
    @Autowired
    private ConsumptionPassTaskListener consumptionPassTaskListener;
    @Autowired
    private ConsumptionRejectProcessListener consumptionRejectProcessListener;
    @Autowired
    private ConsumptionCancelProcessListener consumptionCancelProcessListener;
    @Autowired
    private WorkflowApproverService workflowApproverService;
    @Autowired
    private NewConsumptionProcessDetailHandler newConsumptionProcessDetailHandler;
    @Autowired
    private InlongGroupService groupService;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setType("Data Consumption Resource Creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(NewConsumptionProcessForm.class);
        process.setVersion(1);
        process.setProcessDetailHandler((ProcessDetailHandler)this.newConsumptionProcessDetailHandler);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        UserTask groupOwnerUserTask = new UserTask();
        groupOwnerUserTask.setName(UT_GROUP_OWNER_NAME);
        groupOwnerUserTask.setDisplayName("Group Approval");
        groupOwnerUserTask.setApproverAssign(this::bizOwnerUserTaskApprover);
        process.addTask((WorkflowTask)groupOwnerUserTask);
        UserTask adminUserTask = new UserTask();
        adminUserTask.setName(UT_ADMINT_NAME);
        adminUserTask.setDisplayName("SystemAdmin");
        adminUserTask.setFormClass(ConsumptionApproveForm.class);
        adminUserTask.setApproverAssign(this::adminUserTaskApprover);
        adminUserTask.addListener((TaskEventListener)this.consumptionPassTaskListener);
        process.addTask((WorkflowTask)adminUserTask);
        startEvent.addNext((Element)groupOwnerUserTask);
        groupOwnerUserTask.addNext((Element)adminUserTask);
        adminUserTask.addNext((Element)endEvent);
        process.addListener((ProcessEventListener)this.consumptionCompleteProcessListener);
        process.addListener((ProcessEventListener)this.consumptionRejectProcessListener);
        process.addListener((ProcessEventListener)this.consumptionCancelProcessListener);
        return process;
    }

    private List<String> adminUserTaskApprover(WorkflowContext context) {
        return this.workflowApproverService.getApprovers(this.getProcessName().name(), UT_ADMINT_NAME, new WorkflowApproverFilterContext());
    }

    private List<String> bizOwnerUserTaskApprover(WorkflowContext context) {
        NewConsumptionProcessForm form = (NewConsumptionProcessForm)context.getProcessForm();
        InlongGroupInfo groupInfo = this.groupService.get(form.getConsumptionInfo().getInlongGroupId());
        if (groupInfo == null || groupInfo.getInCharges() == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(groupInfo.getInCharges().split(","));
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.NEW_CONSUMPTION_PROCESS;
    }
}

