/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.consumption.listener;

import java.util.Date;
import org.apache.inlong.manager.common.enums.ConsumptionStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.workflow.form.NewConsumptionProcessForm;
import org.apache.inlong.manager.dao.entity.ConsumptionEntity;
import org.apache.inlong.manager.dao.mapper.ConsumptionEntityMapper;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumptionRejectProcessListener
implements ProcessEventListener {
    private final ConsumptionEntityMapper consumptionEntityMapper;

    @Autowired
    public ConsumptionRejectProcessListener(ConsumptionEntityMapper consumptionEntityMapper) {
        this.consumptionEntityMapper = consumptionEntityMapper;
    }

    public ProcessEvent event() {
        return ProcessEvent.REJECT;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewConsumptionProcessForm processForm = (NewConsumptionProcessForm)context.getProcessForm();
        ConsumptionEntity update = new ConsumptionEntity();
        update.setId(processForm.getConsumptionInfo().getId());
        update.setStatus(Integer.valueOf(ConsumptionStatus.REJECTED.getStatus()));
        update.setModifyTime(new Date());
        this.consumptionEntityMapper.updateByPrimaryKeySelective(update);
        return ListenerResult.success((String)"The application process was rejected");
    }

    public boolean async() {
        return false;
    }
}

