/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group;

import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.group.listener.GroupCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.group.listener.GroupFailedProcessListener;
import org.apache.inlong.manager.service.workflow.group.listener.GroupInitProcessListener;
import org.apache.inlong.manager.service.workflow.listener.GroupTaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateGroupWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(CreateGroupWorkflowDefinition.class);
    @Autowired
    private GroupInitProcessListener groupInitProcessListener;
    @Autowired
    private GroupCompleteProcessListener groupCompleteProcessListener;
    @Autowired
    private GroupFailedProcessListener groupFailedProcessListener;
    @Autowired
    private GroupTaskListenerFactory groupTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.addListener((ProcessEventListener)this.groupInitProcessListener);
        process.addListener((ProcessEventListener)this.groupCompleteProcessListener);
        process.addListener((ProcessEventListener)this.groupFailedProcessListener);
        process.setType("Group Resource Creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(GroupResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask initMQTask = new ServiceTask();
        initMQTask.setName("initMQ");
        initMQTask.setDisplayName("Group-InitMQ");
        initMQTask.addServiceTaskType(ServiceTaskType.INIT_MQ);
        initMQTask.addListenerProvider((ServiceTaskListenerProvider)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)initMQTask);
        ServiceTask initSinkTask = new ServiceTask();
        initSinkTask.setName("initSink");
        initSinkTask.setDisplayName("Group-InitSink");
        initSinkTask.addServiceTaskType(ServiceTaskType.INIT_SINK);
        initSinkTask.addListenerProvider((ServiceTaskListenerProvider)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)initSinkTask);
        ServiceTask initSortTask = new ServiceTask();
        initSortTask.setName("initSort");
        initSortTask.setDisplayName("Group-InitSort");
        initSortTask.addServiceTaskType(ServiceTaskType.INIT_SORT);
        initSortTask.addListenerProvider((ServiceTaskListenerProvider)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)initSortTask);
        ServiceTask initSourceTask = new ServiceTask();
        initSourceTask.setName("initSource");
        initSourceTask.setDisplayName("Group-InitSource");
        initSourceTask.addServiceTaskType(ServiceTaskType.INIT_SOURCE);
        initSourceTask.addListenerProvider((ServiceTaskListenerProvider)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)initSourceTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)initMQTask);
        initMQTask.addNext((Element)initSinkTask);
        initSinkTask.addNext((Element)initSortTask);
        initSortTask.addNext((Element)initSourceTask);
        initSourceTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_GROUP_RESOURCE;
    }
}

