/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group;

import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.group.listener.GroupUpdateCompleteListener;
import org.apache.inlong.manager.service.workflow.group.listener.GroupUpdateFailedListener;
import org.apache.inlong.manager.service.workflow.group.listener.GroupUpdateListener;
import org.apache.inlong.manager.service.workflow.listener.GroupTaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestartGroupWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(RestartGroupWorkflowDefinition.class);
    @Autowired
    private GroupUpdateListener groupUpdateListener;
    @Autowired
    private GroupUpdateCompleteListener groupUpdateCompleteListener;
    @Autowired
    private GroupUpdateFailedListener groupUpdateFailedListener;
    @Autowired
    private GroupTaskListenerFactory groupTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.addListener((ProcessEventListener)this.groupUpdateListener);
        process.addListener((ProcessEventListener)this.groupUpdateCompleteListener);
        process.addListener((ProcessEventListener)this.groupUpdateFailedListener);
        process.setType("Group Resource Restart");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(GroupResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask restartSortTask = new ServiceTask();
        restartSortTask.setName("restartSort");
        restartSortTask.setDisplayName("Group-RestartSort");
        restartSortTask.addServiceTaskType(ServiceTaskType.RESTART_SORT);
        restartSortTask.addListenerProvider((ServiceTaskListenerProvider)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)restartSortTask);
        ServiceTask restartDataSourceTask = new ServiceTask();
        restartDataSourceTask.setName("restartSource");
        restartDataSourceTask.setDisplayName("Group-RestartSource");
        restartDataSourceTask.addServiceTaskType(ServiceTaskType.RESTART_SOURCE);
        restartDataSourceTask.addListenerProvider((ServiceTaskListenerProvider)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)restartDataSourceTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)restartSortTask);
        restartSortTask.addNext((Element)restartDataSourceTask);
        restartDataSourceTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.RESTART_GROUP_PROCESS;
    }
}

