/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group;

import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.group.listener.GroupUpdateCompleteListener;
import org.apache.inlong.manager.service.workflow.group.listener.GroupUpdateFailedListener;
import org.apache.inlong.manager.service.workflow.group.listener.GroupUpdateListener;
import org.apache.inlong.manager.service.workflow.listener.GroupTaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SuspendGroupWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(SuspendGroupWorkflowDefinition.class);
    @Autowired
    private GroupUpdateListener groupUpdateListener;
    @Autowired
    private GroupUpdateCompleteListener groupUpdateCompleteListener;
    @Autowired
    private GroupUpdateFailedListener groupUpdateFailedListener;
    @Autowired
    private GroupTaskListenerFactory groupTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.addListener((ProcessEventListener)this.groupUpdateListener);
        process.addListener((ProcessEventListener)this.groupUpdateCompleteListener);
        process.addListener((ProcessEventListener)this.groupUpdateFailedListener);
        process.setType("Group Resource Suspend");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(GroupResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask stopDataSourceTask = new ServiceTask();
        stopDataSourceTask.setName("stopSource");
        stopDataSourceTask.setDisplayName("Group-StopSource");
        stopDataSourceTask.addServiceTaskType(ServiceTaskType.STOP_SOURCE);
        stopDataSourceTask.addListenerProvider((ServiceTaskListenerProvider)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)stopDataSourceTask);
        ServiceTask stopSortTask = new ServiceTask();
        stopSortTask.setName("stopSort");
        stopSortTask.setDisplayName("Group-StopSort");
        stopSortTask.addServiceTaskType(ServiceTaskType.STOP_SORT);
        stopSortTask.addListenerProvider((ServiceTaskListenerProvider)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)stopSortTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)stopDataSourceTask);
        stopDataSourceTask.addNext((Element)stopSortTask);
        stopSortTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.SUSPEND_GROUP_PROCESS;
    }
}

