/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.light;

import org.apache.inlong.manager.common.pojo.workflow.form.LightGroupResourceProcessForm;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.group.listener.light.LightGroupUpdateCompleteListener;
import org.apache.inlong.manager.service.workflow.group.listener.light.LightGroupUpdateFailedListener;
import org.apache.inlong.manager.service.workflow.group.listener.light.LightGroupUpdateListener;
import org.apache.inlong.manager.service.workflow.listener.GroupTaskListenerFactory;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteLightGroupWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(DeleteLightGroupWorkflowDefinition.class);
    @Autowired
    private LightGroupUpdateListener lightGroupUpdateListener;
    @Autowired
    private LightGroupUpdateCompleteListener lightGroupUpdateCompleteListener;
    @Autowired
    private LightGroupUpdateFailedListener lightGroupUpdateFailedListener;
    @Autowired
    private GroupTaskListenerFactory groupTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.addListener((ProcessEventListener)this.lightGroupUpdateListener);
        process.addListener((ProcessEventListener)this.lightGroupUpdateCompleteListener);
        process.addListener((ProcessEventListener)this.lightGroupUpdateFailedListener);
        process.setType("Group Resource Delete");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(LightGroupResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask deleteSortTask = new ServiceTask();
        deleteSortTask.setName("deleteSort");
        deleteSortTask.setDisplayName("Group-DeleteSort");
        deleteSortTask.addServiceTaskType(ServiceTaskType.DELETE_SORT);
        deleteSortTask.addListenerProvider((ServiceTaskListenerProvider)this.groupTaskListenerFactory);
        process.addTask((WorkflowTask)deleteSortTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)deleteSortTask);
        deleteSortTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.DELETE_LIGHT_GROUP_PROCESS;
    }
}

