/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener;

import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupUpdateCompleteListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(GroupUpdateCompleteListener.class);
    @Autowired
    private InlongGroupService groupService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        Integer nextStatus;
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String operator = context.getOperator();
        GroupOperateType operateType = form.getGroupOperateType();
        InlongGroupInfo groupInfo = form.getGroupInfo();
        switch (operateType) {
            case RESTART: {
                nextStatus = GroupStatus.RESTARTED.getCode();
                break;
            }
            case SUSPEND: {
                nextStatus = GroupStatus.SUSPENDED.getCode();
                break;
            }
            case DELETE: {
                nextStatus = GroupStatus.DELETED.getCode();
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unsupported operation=%s for inlong group", operateType));
            }
        }
        this.groupService.updateStatus(groupInfo.getInlongGroupId(), nextStatus, operator);
        this.groupService.update(groupInfo.genRequest(), operator);
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

