/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener.approve;

import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupMode;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.LightGroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.NewGroupProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupApproveProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(GroupApproveProcessListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private InlongStreamService streamService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        NewGroupProcessForm form = (NewGroupProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupMode mode = GroupMode.parseGroupMode((InlongGroupInfo)groupInfo);
        switch (mode) {
            case NORMAL: {
                this.createGroupResource(context, groupInfo);
                break;
            }
            case LIGHT: {
                this.createLightGroupResource(context, groupInfo);
                break;
            }
            default: {
                throw new WorkflowListenerException(ErrorCodeEnum.GROUP_MODE_UNSUPPORTED.getMessage());
            }
        }
        return ListenerResult.success();
    }

    private void createGroupResource(WorkflowContext context, InlongGroupInfo groupInfo) {
        GroupResourceProcessForm processForm = new GroupResourceProcessForm();
        processForm.setGroupInfo(groupInfo);
        String username = context.getOperator();
        String groupId = groupInfo.getInlongGroupId();
        List<InlongStreamInfo> streamList = this.streamService.list(groupId);
        processForm.setStreamInfos(streamList);
        this.workflowService.start(ProcessName.CREATE_GROUP_RESOURCE, username, (ProcessForm)processForm);
    }

    private void createLightGroupResource(WorkflowContext context, InlongGroupInfo groupInfo) {
        LightGroupResourceProcessForm processForm = new LightGroupResourceProcessForm();
        processForm.setGroupInfo(groupInfo);
        String username = context.getOperator();
        String groupId = groupInfo.getInlongGroupId();
        List<InlongStreamInfo> streamList = this.streamService.list(groupId);
        processForm.setStreamInfos(streamList);
        this.workflowService.start(ProcessName.CREATE_LIGHT_GROUP_PROCESS, username, (ProcessForm)processForm);
    }

    public boolean async() {
        return true;
    }
}

