/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener.light;

import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.pojo.workflow.form.LightGroupResourceProcessForm;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LightGroupFailedListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(LightGroupFailedListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;

    public ProcessEvent event() {
        return ProcessEvent.FAIL;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        LightGroupResourceProcessForm form = (LightGroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getGroupInfo().getInlongGroupId();
        String applicant = context.getOperator();
        this.groupService.updateStatus(groupId, GroupStatus.CONFIG_FAILED.getCode(), applicant);
        this.groupService.update(form.getGroupInfo().genRequest(), applicant);
        this.streamService.updateStatus(groupId, null, StreamStatus.CONFIG_FAILED.getCode(), applicant);
        return ListenerResult.fail();
    }

    public boolean async() {
        return false;
    }
}

