/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener.light;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.LightGroupResourceProcessForm;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LightGroupInitListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(LightGroupInitListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;

    public ProcessEvent event() {
        return ProcessEvent.CREATE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        LightGroupResourceProcessForm form = (LightGroupResourceProcessForm)context.getProcessForm();
        InlongGroupInfo groupInfo = form.getGroupInfo();
        if (groupInfo == null) {
            throw new WorkflowListenerException(ErrorCodeEnum.GROUP_NOT_FOUND.getMessage());
        }
        String groupId = groupInfo.getInlongGroupId();
        int status = GroupStatus.CONFIG_ING.getCode();
        String username = context.getOperator();
        this.groupService.updateStatus(groupInfo.getInlongGroupId(), status, username);
        if (CollectionUtils.isEmpty((Collection)form.getStreamInfos())) {
            List<InlongStreamInfo> streamInfos = this.streamService.list(groupId);
            form.setStreamInfos(streamInfos);
        }
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

