/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.group.listener.light;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.LightGroupResourceProcessForm;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LightGroupUpdateCompleteListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(LightGroupUpdateCompleteListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private StreamSourceService sourceService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        LightGroupResourceProcessForm form = (LightGroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        String applicant = context.getOperator();
        GroupOperateType groupOperateType = form.getGroupOperateType();
        switch (groupOperateType) {
            case SUSPEND: {
                this.groupService.updateStatus(groupId, GroupStatus.SUSPENDED.getCode(), applicant);
                this.sourceService.updateStatus(groupId, null, SourceStatus.SOURCE_FROZEN.getCode(), applicant);
                break;
            }
            case RESTART: {
                this.groupService.updateStatus(groupId, GroupStatus.RESTARTED.getCode(), applicant);
                this.sourceService.updateStatus(groupId, null, SourceStatus.SOURCE_NORMAL.getCode(), applicant);
                break;
            }
            case DELETE: {
                this.groupService.updateStatus(groupId, GroupStatus.DELETED.getCode(), applicant);
                this.sourceService.logicDeleteAll(groupId, null, applicant);
                break;
            }
        }
        if (CollectionUtils.isEmpty((Collection)form.getStreamInfos())) {
            List<InlongStreamInfo> streamInfos = this.streamService.list(groupId);
            form.setStreamInfos(streamInfos);
        }
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

