/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.listener;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.manager.service.mq.CreatePulsarGroupTaskListener;
import org.apache.inlong.manager.service.mq.CreatePulsarResourceTaskListener;
import org.apache.inlong.manager.service.mq.CreateTubeGroupTaskListener;
import org.apache.inlong.manager.service.mq.CreateTubeTopicTaskListener;
import org.apache.inlong.manager.service.mq.PulsarEventSelector;
import org.apache.inlong.manager.service.mq.TubeEventSelector;
import org.apache.inlong.manager.service.resource.SinkResourceListener;
import org.apache.inlong.manager.service.sort.CreateSortConfigListenerV2;
import org.apache.inlong.manager.service.sort.ZookeeperDisabledSelector;
import org.apache.inlong.manager.service.sort.light.LightGroupSortListener;
import org.apache.inlong.manager.service.sort.light.LightGroupSortSelector;
import org.apache.inlong.manager.service.source.listener.SourceDeleteEventSelector;
import org.apache.inlong.manager.service.source.listener.SourceDeleteListener;
import org.apache.inlong.manager.service.source.listener.SourceRestartEventSelector;
import org.apache.inlong.manager.service.source.listener.SourceRestartListener;
import org.apache.inlong.manager.service.source.listener.SourceStopEventSelector;
import org.apache.inlong.manager.service.source.listener.SourceStopListener;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.apache.inlong.manager.workflow.event.task.DataSourceOperateListener;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.plugin.Plugin;
import org.apache.inlong.manager.workflow.plugin.PluginBinder;
import org.apache.inlong.manager.workflow.plugin.ProcessPlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupTaskListenerFactory
implements PluginBinder,
ServiceTaskListenerProvider {
    private Map<DataSourceOperateListener, EventSelector> sourceOperateListeners;
    private Map<QueueOperateListener, EventSelector> queueOperateListeners;
    private Map<SortOperateListener, EventSelector> sortOperateListeners;
    @Autowired
    private SourceStopListener sourceStopListener;
    @Autowired
    private SourceRestartListener sourceRestartListener;
    @Autowired
    private SourceDeleteListener sourceDeleteListener;
    @Autowired
    private CreateTubeTopicTaskListener createTubeTopicTaskListener;
    @Autowired
    private CreateTubeGroupTaskListener createTubeGroupTaskListener;
    @Autowired
    private CreatePulsarResourceTaskListener createPulsarResourceTaskListener;
    @Autowired
    private CreatePulsarGroupTaskListener createPulsarGroupTaskListener;
    @Autowired
    private SinkResourceListener sinkResourceListener;
    @Autowired
    private CreateSortConfigListenerV2 createSortConfigListener;
    @Autowired
    private LightGroupSortListener lightGroupSortListener;

    @PostConstruct
    public void init() {
        this.sourceOperateListeners = new LinkedHashMap<DataSourceOperateListener, EventSelector>();
        this.sourceOperateListeners.put(this.sourceStopListener, new SourceStopEventSelector());
        this.sourceOperateListeners.put(this.sourceDeleteListener, new SourceDeleteEventSelector());
        this.sourceOperateListeners.put(this.sourceRestartListener, new SourceRestartEventSelector());
        this.queueOperateListeners = new LinkedHashMap<QueueOperateListener, EventSelector>();
        this.queueOperateListeners.put(this.createTubeTopicTaskListener, new TubeEventSelector());
        this.queueOperateListeners.put(this.createTubeGroupTaskListener, new TubeEventSelector());
        this.queueOperateListeners.put(this.createPulsarResourceTaskListener, new PulsarEventSelector());
        this.queueOperateListeners.put(this.createPulsarGroupTaskListener, new PulsarEventSelector());
        this.sortOperateListeners = new LinkedHashMap<SortOperateListener, EventSelector>();
        this.sortOperateListeners.put(this.createSortConfigListener, new ZookeeperDisabledSelector());
        this.sortOperateListeners.put(this.lightGroupSortListener, new LightGroupSortSelector());
    }

    public void clearListeners() {
        this.sourceOperateListeners = new LinkedHashMap<DataSourceOperateListener, EventSelector>();
        this.queueOperateListeners = new LinkedHashMap<QueueOperateListener, EventSelector>();
        this.sortOperateListeners = new LinkedHashMap<SortOperateListener, EventSelector>();
    }

    public List<TaskEventListener> get(WorkflowContext workflowContext, ServiceTaskType serviceTaskType) {
        switch (serviceTaskType) {
            case INIT_MQ: {
                List<QueueOperateListener> queueOperateListeners = this.getQueueOperateListener(workflowContext);
                return Lists.newArrayList(queueOperateListeners);
            }
            case INIT_SORT: 
            case STOP_SORT: 
            case RESTART_SORT: 
            case DELETE_SORT: {
                List<SortOperateListener> sortOperateListeners = this.getSortOperateListener(workflowContext);
                return Lists.newArrayList(sortOperateListeners);
            }
            case INIT_SOURCE: 
            case STOP_SOURCE: 
            case RESTART_SOURCE: 
            case DELETE_SOURCE: {
                List<DataSourceOperateListener> sourceOperateListeners = this.getSourceOperateListener(workflowContext);
                return Lists.newArrayList(sourceOperateListeners);
            }
            case INIT_SINK: {
                return Collections.singletonList(this.sinkResourceListener);
            }
        }
        throw new IllegalArgumentException(String.format("UnSupport ServiceTaskType %s", serviceTaskType));
    }

    public List<DataSourceOperateListener> getSourceOperateListener(WorkflowContext context) {
        ArrayList<DataSourceOperateListener> listeners = new ArrayList<DataSourceOperateListener>();
        for (Map.Entry<DataSourceOperateListener, EventSelector> entry : this.sourceOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<QueueOperateListener> getQueueOperateListener(WorkflowContext context) {
        ArrayList<QueueOperateListener> listeners = new ArrayList<QueueOperateListener>();
        for (Map.Entry<QueueOperateListener, EventSelector> entry : this.queueOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<SortOperateListener> getSortOperateListener(WorkflowContext context) {
        ArrayList<SortOperateListener> listeners = new ArrayList<SortOperateListener>();
        for (Map.Entry<SortOperateListener, EventSelector> entry : this.sortOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public void acceptPlugin(Plugin plugin) {
        Map pluginSortOperateListeners;
        Map pluginQueueOperateListeners;
        if (!(plugin instanceof ProcessPlugin)) {
            return;
        }
        ProcessPlugin processPlugin = (ProcessPlugin)plugin;
        Map pluginDsOperateListeners = processPlugin.createSourceOperateListeners();
        if (MapUtils.isNotEmpty((Map)pluginDsOperateListeners)) {
            this.sourceOperateListeners.putAll(processPlugin.createSourceOperateListeners());
        }
        if (MapUtils.isNotEmpty((Map)(pluginQueueOperateListeners = processPlugin.createQueueOperateListeners()))) {
            this.queueOperateListeners.putAll(pluginQueueOperateListeners);
        }
        if (MapUtils.isNotEmpty((Map)(pluginSortOperateListeners = processPlugin.createSortOperateListeners()))) {
            this.sortOperateListeners.putAll(pluginSortOperateListeners);
        }
    }

    public Map<DataSourceOperateListener, EventSelector> getSourceOperateListeners() {
        return this.sourceOperateListeners;
    }

    public Map<QueueOperateListener, EventSelector> getQueueOperateListeners() {
        return this.queueOperateListeners;
    }

    public Map<SortOperateListener, EventSelector> getSortOperateListeners() {
        return this.sortOperateListeners;
    }

    public SourceStopListener getSourceStopListener() {
        return this.sourceStopListener;
    }

    public SourceRestartListener getSourceRestartListener() {
        return this.sourceRestartListener;
    }

    public SourceDeleteListener getSourceDeleteListener() {
        return this.sourceDeleteListener;
    }

    public CreateTubeTopicTaskListener getCreateTubeTopicTaskListener() {
        return this.createTubeTopicTaskListener;
    }

    public CreateTubeGroupTaskListener getCreateTubeGroupTaskListener() {
        return this.createTubeGroupTaskListener;
    }

    public CreatePulsarResourceTaskListener getCreatePulsarResourceTaskListener() {
        return this.createPulsarResourceTaskListener;
    }

    public CreatePulsarGroupTaskListener getCreatePulsarGroupTaskListener() {
        return this.createPulsarGroupTaskListener;
    }

    public SinkResourceListener getSinkResourceListener() {
        return this.sinkResourceListener;
    }

    public CreateSortConfigListenerV2 getCreateSortConfigListener() {
        return this.createSortConfigListener;
    }

    public LightGroupSortListener getLightGroupSortListener() {
        return this.lightGroupSortListener;
    }

    public void setSourceOperateListeners(Map<DataSourceOperateListener, EventSelector> sourceOperateListeners) {
        this.sourceOperateListeners = sourceOperateListeners;
    }

    public void setQueueOperateListeners(Map<QueueOperateListener, EventSelector> queueOperateListeners) {
        this.queueOperateListeners = queueOperateListeners;
    }

    public void setSortOperateListeners(Map<SortOperateListener, EventSelector> sortOperateListeners) {
        this.sortOperateListeners = sortOperateListeners;
    }

    public void setSourceStopListener(SourceStopListener sourceStopListener) {
        this.sourceStopListener = sourceStopListener;
    }

    public void setSourceRestartListener(SourceRestartListener sourceRestartListener) {
        this.sourceRestartListener = sourceRestartListener;
    }

    public void setSourceDeleteListener(SourceDeleteListener sourceDeleteListener) {
        this.sourceDeleteListener = sourceDeleteListener;
    }

    public void setCreateTubeTopicTaskListener(CreateTubeTopicTaskListener createTubeTopicTaskListener) {
        this.createTubeTopicTaskListener = createTubeTopicTaskListener;
    }

    public void setCreateTubeGroupTaskListener(CreateTubeGroupTaskListener createTubeGroupTaskListener) {
        this.createTubeGroupTaskListener = createTubeGroupTaskListener;
    }

    public void setCreatePulsarResourceTaskListener(CreatePulsarResourceTaskListener createPulsarResourceTaskListener) {
        this.createPulsarResourceTaskListener = createPulsarResourceTaskListener;
    }

    public void setCreatePulsarGroupTaskListener(CreatePulsarGroupTaskListener createPulsarGroupTaskListener) {
        this.createPulsarGroupTaskListener = createPulsarGroupTaskListener;
    }

    public void setSinkResourceListener(SinkResourceListener sinkResourceListener) {
        this.sinkResourceListener = sinkResourceListener;
    }

    public void setCreateSortConfigListener(CreateSortConfigListenerV2 createSortConfigListener) {
        this.createSortConfigListener = createSortConfigListener;
    }

    public void setLightGroupSortListener(LightGroupSortListener lightGroupSortListener) {
        this.lightGroupSortListener = lightGroupSortListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupTaskListenerFactory)) {
            return false;
        }
        GroupTaskListenerFactory other = (GroupTaskListenerFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<DataSourceOperateListener, EventSelector> this$sourceOperateListeners = this.getSourceOperateListeners();
        Map<DataSourceOperateListener, EventSelector> other$sourceOperateListeners = other.getSourceOperateListeners();
        if (this$sourceOperateListeners == null ? other$sourceOperateListeners != null : !((Object)this$sourceOperateListeners).equals(other$sourceOperateListeners)) {
            return false;
        }
        Map<QueueOperateListener, EventSelector> this$queueOperateListeners = this.getQueueOperateListeners();
        Map<QueueOperateListener, EventSelector> other$queueOperateListeners = other.getQueueOperateListeners();
        if (this$queueOperateListeners == null ? other$queueOperateListeners != null : !((Object)this$queueOperateListeners).equals(other$queueOperateListeners)) {
            return false;
        }
        Map<SortOperateListener, EventSelector> this$sortOperateListeners = this.getSortOperateListeners();
        Map<SortOperateListener, EventSelector> other$sortOperateListeners = other.getSortOperateListeners();
        if (this$sortOperateListeners == null ? other$sortOperateListeners != null : !((Object)this$sortOperateListeners).equals(other$sortOperateListeners)) {
            return false;
        }
        SourceStopListener this$sourceStopListener = this.getSourceStopListener();
        SourceStopListener other$sourceStopListener = other.getSourceStopListener();
        if (this$sourceStopListener == null ? other$sourceStopListener != null : !this$sourceStopListener.equals(other$sourceStopListener)) {
            return false;
        }
        SourceRestartListener this$sourceRestartListener = this.getSourceRestartListener();
        SourceRestartListener other$sourceRestartListener = other.getSourceRestartListener();
        if (this$sourceRestartListener == null ? other$sourceRestartListener != null : !this$sourceRestartListener.equals(other$sourceRestartListener)) {
            return false;
        }
        SourceDeleteListener this$sourceDeleteListener = this.getSourceDeleteListener();
        SourceDeleteListener other$sourceDeleteListener = other.getSourceDeleteListener();
        if (this$sourceDeleteListener == null ? other$sourceDeleteListener != null : !this$sourceDeleteListener.equals(other$sourceDeleteListener)) {
            return false;
        }
        CreateTubeTopicTaskListener this$createTubeTopicTaskListener = this.getCreateTubeTopicTaskListener();
        CreateTubeTopicTaskListener other$createTubeTopicTaskListener = other.getCreateTubeTopicTaskListener();
        if (this$createTubeTopicTaskListener == null ? other$createTubeTopicTaskListener != null : !this$createTubeTopicTaskListener.equals(other$createTubeTopicTaskListener)) {
            return false;
        }
        CreateTubeGroupTaskListener this$createTubeGroupTaskListener = this.getCreateTubeGroupTaskListener();
        CreateTubeGroupTaskListener other$createTubeGroupTaskListener = other.getCreateTubeGroupTaskListener();
        if (this$createTubeGroupTaskListener == null ? other$createTubeGroupTaskListener != null : !this$createTubeGroupTaskListener.equals(other$createTubeGroupTaskListener)) {
            return false;
        }
        CreatePulsarResourceTaskListener this$createPulsarResourceTaskListener = this.getCreatePulsarResourceTaskListener();
        CreatePulsarResourceTaskListener other$createPulsarResourceTaskListener = other.getCreatePulsarResourceTaskListener();
        if (this$createPulsarResourceTaskListener == null ? other$createPulsarResourceTaskListener != null : !this$createPulsarResourceTaskListener.equals(other$createPulsarResourceTaskListener)) {
            return false;
        }
        CreatePulsarGroupTaskListener this$createPulsarGroupTaskListener = this.getCreatePulsarGroupTaskListener();
        CreatePulsarGroupTaskListener other$createPulsarGroupTaskListener = other.getCreatePulsarGroupTaskListener();
        if (this$createPulsarGroupTaskListener == null ? other$createPulsarGroupTaskListener != null : !this$createPulsarGroupTaskListener.equals(other$createPulsarGroupTaskListener)) {
            return false;
        }
        SinkResourceListener this$sinkResourceListener = this.getSinkResourceListener();
        SinkResourceListener other$sinkResourceListener = other.getSinkResourceListener();
        if (this$sinkResourceListener == null ? other$sinkResourceListener != null : !this$sinkResourceListener.equals(other$sinkResourceListener)) {
            return false;
        }
        CreateSortConfigListenerV2 this$createSortConfigListener = this.getCreateSortConfigListener();
        CreateSortConfigListenerV2 other$createSortConfigListener = other.getCreateSortConfigListener();
        if (this$createSortConfigListener == null ? other$createSortConfigListener != null : !this$createSortConfigListener.equals(other$createSortConfigListener)) {
            return false;
        }
        LightGroupSortListener this$lightGroupSortListener = this.getLightGroupSortListener();
        LightGroupSortListener other$lightGroupSortListener = other.getLightGroupSortListener();
        return !(this$lightGroupSortListener == null ? other$lightGroupSortListener != null : !this$lightGroupSortListener.equals(other$lightGroupSortListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupTaskListenerFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<DataSourceOperateListener, EventSelector> $sourceOperateListeners = this.getSourceOperateListeners();
        result = result * 59 + ($sourceOperateListeners == null ? 43 : ((Object)$sourceOperateListeners).hashCode());
        Map<QueueOperateListener, EventSelector> $queueOperateListeners = this.getQueueOperateListeners();
        result = result * 59 + ($queueOperateListeners == null ? 43 : ((Object)$queueOperateListeners).hashCode());
        Map<SortOperateListener, EventSelector> $sortOperateListeners = this.getSortOperateListeners();
        result = result * 59 + ($sortOperateListeners == null ? 43 : ((Object)$sortOperateListeners).hashCode());
        SourceStopListener $sourceStopListener = this.getSourceStopListener();
        result = result * 59 + ($sourceStopListener == null ? 43 : $sourceStopListener.hashCode());
        SourceRestartListener $sourceRestartListener = this.getSourceRestartListener();
        result = result * 59 + ($sourceRestartListener == null ? 43 : $sourceRestartListener.hashCode());
        SourceDeleteListener $sourceDeleteListener = this.getSourceDeleteListener();
        result = result * 59 + ($sourceDeleteListener == null ? 43 : $sourceDeleteListener.hashCode());
        CreateTubeTopicTaskListener $createTubeTopicTaskListener = this.getCreateTubeTopicTaskListener();
        result = result * 59 + ($createTubeTopicTaskListener == null ? 43 : $createTubeTopicTaskListener.hashCode());
        CreateTubeGroupTaskListener $createTubeGroupTaskListener = this.getCreateTubeGroupTaskListener();
        result = result * 59 + ($createTubeGroupTaskListener == null ? 43 : $createTubeGroupTaskListener.hashCode());
        CreatePulsarResourceTaskListener $createPulsarResourceTaskListener = this.getCreatePulsarResourceTaskListener();
        result = result * 59 + ($createPulsarResourceTaskListener == null ? 43 : $createPulsarResourceTaskListener.hashCode());
        CreatePulsarGroupTaskListener $createPulsarGroupTaskListener = this.getCreatePulsarGroupTaskListener();
        result = result * 59 + ($createPulsarGroupTaskListener == null ? 43 : $createPulsarGroupTaskListener.hashCode());
        SinkResourceListener $sinkResourceListener = this.getSinkResourceListener();
        result = result * 59 + ($sinkResourceListener == null ? 43 : $sinkResourceListener.hashCode());
        CreateSortConfigListenerV2 $createSortConfigListener = this.getCreateSortConfigListener();
        result = result * 59 + ($createSortConfigListener == null ? 43 : $createSortConfigListener.hashCode());
        LightGroupSortListener $lightGroupSortListener = this.getLightGroupSortListener();
        result = result * 59 + ($lightGroupSortListener == null ? 43 : $lightGroupSortListener.hashCode());
        return result;
    }

    public String toString() {
        return "GroupTaskListenerFactory(sourceOperateListeners=" + this.getSourceOperateListeners() + ", queueOperateListeners=" + this.getQueueOperateListeners() + ", sortOperateListeners=" + this.getSortOperateListeners() + ", sourceStopListener=" + this.getSourceStopListener() + ", sourceRestartListener=" + this.getSourceRestartListener() + ", sourceDeleteListener=" + this.getSourceDeleteListener() + ", createTubeTopicTaskListener=" + this.getCreateTubeTopicTaskListener() + ", createTubeGroupTaskListener=" + this.getCreateTubeGroupTaskListener() + ", createPulsarResourceTaskListener=" + this.getCreatePulsarResourceTaskListener() + ", createPulsarGroupTaskListener=" + this.getCreatePulsarGroupTaskListener() + ", sinkResourceListener=" + this.getSinkResourceListener() + ", createSortConfigListener=" + this.getCreateSortConfigListener() + ", lightGroupSortListener=" + this.getLightGroupSortListener() + ")";
    }
}

