/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.listener;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.MapUtils;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.service.mq.CreatePulsarSubscriptionTaskListener;
import org.apache.inlong.manager.service.mq.CreatePulsarTopicTaskListener;
import org.apache.inlong.manager.service.mq.PulsarTopicSelector;
import org.apache.inlong.manager.service.resource.StreamSinkResourceListener;
import org.apache.inlong.manager.service.sort.CreateStreamSortConfigListener;
import org.apache.inlong.manager.service.sort.ZookeeperEnabledSelector;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.apache.inlong.manager.workflow.event.task.DataSourceOperateListener;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.SinkOperateListener;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.plugin.Plugin;
import org.apache.inlong.manager.workflow.plugin.PluginBinder;
import org.apache.inlong.manager.workflow.plugin.ProcessPlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreamTaskListenerFactory
implements PluginBinder,
ServiceTaskListenerProvider {
    private Map<DataSourceOperateListener, EventSelector> sourceOperateListeners;
    private Map<QueueOperateListener, EventSelector> queueOperateListeners;
    private Map<SortOperateListener, EventSelector> sortOperateListeners;
    private Map<SinkOperateListener, EventSelector> sinkOperateListeners;
    @Autowired
    private CreatePulsarTopicTaskListener createPulsarTopicTaskListener;
    @Autowired
    private CreatePulsarSubscriptionTaskListener createPulsarSubscriptionTaskListener;
    @Autowired
    private CreateStreamSortConfigListener createSortConfigListener;
    @Autowired
    private StreamSinkResourceListener sinkResourceListener;

    @PostConstruct
    public void init() {
        this.sourceOperateListeners = new LinkedHashMap<DataSourceOperateListener, EventSelector>();
        this.queueOperateListeners = new LinkedHashMap<QueueOperateListener, EventSelector>();
        this.queueOperateListeners.put(this.createPulsarTopicTaskListener, new PulsarTopicSelector());
        this.queueOperateListeners.put(this.createPulsarSubscriptionTaskListener, new PulsarTopicSelector());
        this.sortOperateListeners = new LinkedHashMap<SortOperateListener, EventSelector>();
        this.sortOperateListeners.put(this.createSortConfigListener, new ZookeeperEnabledSelector());
        this.sinkOperateListeners = new LinkedHashMap<SinkOperateListener, EventSelector>();
        this.sinkOperateListeners.put(this.sinkResourceListener, context -> {
            ProcessForm processForm = context.getProcessForm();
            return processForm instanceof StreamResourceProcessForm;
        });
    }

    public Iterable get(WorkflowContext workflowContext, ServiceTaskType serviceTaskType) {
        switch (serviceTaskType) {
            case INIT_MQ: {
                List<QueueOperateListener> queueOperateListeners = this.getQueueOperateListener(workflowContext);
                return Lists.newArrayList(queueOperateListeners);
            }
            case INIT_SORT: 
            case STOP_SORT: 
            case RESTART_SORT: 
            case DELETE_SORT: {
                List<SortOperateListener> sortOperateListeners = this.getSortOperateListener(workflowContext);
                return Lists.newArrayList(sortOperateListeners);
            }
            case INIT_SOURCE: 
            case STOP_SOURCE: 
            case RESTART_SOURCE: 
            case DELETE_SOURCE: {
                List<DataSourceOperateListener> sourceOperateListeners = this.getSourceOperateListener(workflowContext);
                return Lists.newArrayList(sourceOperateListeners);
            }
            case INIT_SINK: {
                List<SinkOperateListener> sinkOperateListeners = this.getSinkOperateListener(workflowContext);
                return Lists.newArrayList(sinkOperateListeners);
            }
        }
        throw new IllegalArgumentException(String.format("UnSupport ServiceTaskType %s", serviceTaskType));
    }

    public List<DataSourceOperateListener> getSourceOperateListener(WorkflowContext context) {
        ArrayList<DataSourceOperateListener> listeners = new ArrayList<DataSourceOperateListener>();
        for (Map.Entry<DataSourceOperateListener, EventSelector> entry : this.sourceOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<QueueOperateListener> getQueueOperateListener(WorkflowContext context) {
        ArrayList<QueueOperateListener> listeners = new ArrayList<QueueOperateListener>();
        for (Map.Entry<QueueOperateListener, EventSelector> entry : this.queueOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<SortOperateListener> getSortOperateListener(WorkflowContext context) {
        ArrayList<SortOperateListener> listeners = new ArrayList<SortOperateListener>();
        for (Map.Entry<SortOperateListener, EventSelector> entry : this.sortOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public List<SinkOperateListener> getSinkOperateListener(WorkflowContext context) {
        ArrayList<SinkOperateListener> listeners = new ArrayList<SinkOperateListener>();
        for (Map.Entry<SinkOperateListener, EventSelector> entry : this.sinkOperateListeners.entrySet()) {
            EventSelector selector = entry.getValue();
            if (selector == null || !selector.accept(context)) continue;
            listeners.add(entry.getKey());
        }
        return listeners;
    }

    public void acceptPlugin(Plugin plugin) {
        Map pluginSinkOperateListeners;
        Map pluginSortOperateListeners;
        Map pluginQueueOperateListeners;
        if (!(plugin instanceof ProcessPlugin)) {
            return;
        }
        ProcessPlugin processPlugin = (ProcessPlugin)plugin;
        Map pluginDsOperateListeners = processPlugin.createSourceOperateListeners();
        if (MapUtils.isNotEmpty((Map)pluginDsOperateListeners)) {
            this.sourceOperateListeners.putAll(processPlugin.createSourceOperateListeners());
        }
        if (MapUtils.isNotEmpty((Map)(pluginQueueOperateListeners = processPlugin.createQueueOperateListeners()))) {
            this.queueOperateListeners.putAll(pluginQueueOperateListeners);
        }
        if (MapUtils.isNotEmpty((Map)(pluginSortOperateListeners = processPlugin.createSortOperateListeners()))) {
            this.sortOperateListeners.putAll(pluginSortOperateListeners);
        }
        if (MapUtils.isNotEmpty((Map)(pluginSinkOperateListeners = processPlugin.createSinkOperateListeners()))) {
            this.sinkOperateListeners.putAll(pluginSinkOperateListeners);
        }
    }

    public Map<DataSourceOperateListener, EventSelector> getSourceOperateListeners() {
        return this.sourceOperateListeners;
    }

    public Map<QueueOperateListener, EventSelector> getQueueOperateListeners() {
        return this.queueOperateListeners;
    }

    public Map<SortOperateListener, EventSelector> getSortOperateListeners() {
        return this.sortOperateListeners;
    }

    public Map<SinkOperateListener, EventSelector> getSinkOperateListeners() {
        return this.sinkOperateListeners;
    }

    public CreatePulsarTopicTaskListener getCreatePulsarTopicTaskListener() {
        return this.createPulsarTopicTaskListener;
    }

    public CreatePulsarSubscriptionTaskListener getCreatePulsarSubscriptionTaskListener() {
        return this.createPulsarSubscriptionTaskListener;
    }

    public CreateStreamSortConfigListener getCreateSortConfigListener() {
        return this.createSortConfigListener;
    }

    public StreamSinkResourceListener getSinkResourceListener() {
        return this.sinkResourceListener;
    }

    public void setSourceOperateListeners(Map<DataSourceOperateListener, EventSelector> sourceOperateListeners) {
        this.sourceOperateListeners = sourceOperateListeners;
    }

    public void setQueueOperateListeners(Map<QueueOperateListener, EventSelector> queueOperateListeners) {
        this.queueOperateListeners = queueOperateListeners;
    }

    public void setSortOperateListeners(Map<SortOperateListener, EventSelector> sortOperateListeners) {
        this.sortOperateListeners = sortOperateListeners;
    }

    public void setSinkOperateListeners(Map<SinkOperateListener, EventSelector> sinkOperateListeners) {
        this.sinkOperateListeners = sinkOperateListeners;
    }

    public void setCreatePulsarTopicTaskListener(CreatePulsarTopicTaskListener createPulsarTopicTaskListener) {
        this.createPulsarTopicTaskListener = createPulsarTopicTaskListener;
    }

    public void setCreatePulsarSubscriptionTaskListener(CreatePulsarSubscriptionTaskListener createPulsarSubscriptionTaskListener) {
        this.createPulsarSubscriptionTaskListener = createPulsarSubscriptionTaskListener;
    }

    public void setCreateSortConfigListener(CreateStreamSortConfigListener createSortConfigListener) {
        this.createSortConfigListener = createSortConfigListener;
    }

    public void setSinkResourceListener(StreamSinkResourceListener sinkResourceListener) {
        this.sinkResourceListener = sinkResourceListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamTaskListenerFactory)) {
            return false;
        }
        StreamTaskListenerFactory other = (StreamTaskListenerFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<DataSourceOperateListener, EventSelector> this$sourceOperateListeners = this.getSourceOperateListeners();
        Map<DataSourceOperateListener, EventSelector> other$sourceOperateListeners = other.getSourceOperateListeners();
        if (this$sourceOperateListeners == null ? other$sourceOperateListeners != null : !((Object)this$sourceOperateListeners).equals(other$sourceOperateListeners)) {
            return false;
        }
        Map<QueueOperateListener, EventSelector> this$queueOperateListeners = this.getQueueOperateListeners();
        Map<QueueOperateListener, EventSelector> other$queueOperateListeners = other.getQueueOperateListeners();
        if (this$queueOperateListeners == null ? other$queueOperateListeners != null : !((Object)this$queueOperateListeners).equals(other$queueOperateListeners)) {
            return false;
        }
        Map<SortOperateListener, EventSelector> this$sortOperateListeners = this.getSortOperateListeners();
        Map<SortOperateListener, EventSelector> other$sortOperateListeners = other.getSortOperateListeners();
        if (this$sortOperateListeners == null ? other$sortOperateListeners != null : !((Object)this$sortOperateListeners).equals(other$sortOperateListeners)) {
            return false;
        }
        Map<SinkOperateListener, EventSelector> this$sinkOperateListeners = this.getSinkOperateListeners();
        Map<SinkOperateListener, EventSelector> other$sinkOperateListeners = other.getSinkOperateListeners();
        if (this$sinkOperateListeners == null ? other$sinkOperateListeners != null : !((Object)this$sinkOperateListeners).equals(other$sinkOperateListeners)) {
            return false;
        }
        CreatePulsarTopicTaskListener this$createPulsarTopicTaskListener = this.getCreatePulsarTopicTaskListener();
        CreatePulsarTopicTaskListener other$createPulsarTopicTaskListener = other.getCreatePulsarTopicTaskListener();
        if (this$createPulsarTopicTaskListener == null ? other$createPulsarTopicTaskListener != null : !this$createPulsarTopicTaskListener.equals(other$createPulsarTopicTaskListener)) {
            return false;
        }
        CreatePulsarSubscriptionTaskListener this$createPulsarSubscriptionTaskListener = this.getCreatePulsarSubscriptionTaskListener();
        CreatePulsarSubscriptionTaskListener other$createPulsarSubscriptionTaskListener = other.getCreatePulsarSubscriptionTaskListener();
        if (this$createPulsarSubscriptionTaskListener == null ? other$createPulsarSubscriptionTaskListener != null : !this$createPulsarSubscriptionTaskListener.equals(other$createPulsarSubscriptionTaskListener)) {
            return false;
        }
        CreateStreamSortConfigListener this$createSortConfigListener = this.getCreateSortConfigListener();
        CreateStreamSortConfigListener other$createSortConfigListener = other.getCreateSortConfigListener();
        if (this$createSortConfigListener == null ? other$createSortConfigListener != null : !this$createSortConfigListener.equals(other$createSortConfigListener)) {
            return false;
        }
        StreamSinkResourceListener this$sinkResourceListener = this.getSinkResourceListener();
        StreamSinkResourceListener other$sinkResourceListener = other.getSinkResourceListener();
        return !(this$sinkResourceListener == null ? other$sinkResourceListener != null : !this$sinkResourceListener.equals(other$sinkResourceListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamTaskListenerFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<DataSourceOperateListener, EventSelector> $sourceOperateListeners = this.getSourceOperateListeners();
        result = result * 59 + ($sourceOperateListeners == null ? 43 : ((Object)$sourceOperateListeners).hashCode());
        Map<QueueOperateListener, EventSelector> $queueOperateListeners = this.getQueueOperateListeners();
        result = result * 59 + ($queueOperateListeners == null ? 43 : ((Object)$queueOperateListeners).hashCode());
        Map<SortOperateListener, EventSelector> $sortOperateListeners = this.getSortOperateListeners();
        result = result * 59 + ($sortOperateListeners == null ? 43 : ((Object)$sortOperateListeners).hashCode());
        Map<SinkOperateListener, EventSelector> $sinkOperateListeners = this.getSinkOperateListeners();
        result = result * 59 + ($sinkOperateListeners == null ? 43 : ((Object)$sinkOperateListeners).hashCode());
        CreatePulsarTopicTaskListener $createPulsarTopicTaskListener = this.getCreatePulsarTopicTaskListener();
        result = result * 59 + ($createPulsarTopicTaskListener == null ? 43 : $createPulsarTopicTaskListener.hashCode());
        CreatePulsarSubscriptionTaskListener $createPulsarSubscriptionTaskListener = this.getCreatePulsarSubscriptionTaskListener();
        result = result * 59 + ($createPulsarSubscriptionTaskListener == null ? 43 : $createPulsarSubscriptionTaskListener.hashCode());
        CreateStreamSortConfigListener $createSortConfigListener = this.getCreateSortConfigListener();
        result = result * 59 + ($createSortConfigListener == null ? 43 : $createSortConfigListener.hashCode());
        StreamSinkResourceListener $sinkResourceListener = this.getSinkResourceListener();
        result = result * 59 + ($sinkResourceListener == null ? 43 : $sinkResourceListener.hashCode());
        return result;
    }

    public String toString() {
        return "StreamTaskListenerFactory(sourceOperateListeners=" + this.getSourceOperateListeners() + ", queueOperateListeners=" + this.getQueueOperateListeners() + ", sortOperateListeners=" + this.getSortOperateListeners() + ", sinkOperateListeners=" + this.getSinkOperateListeners() + ", createPulsarTopicTaskListener=" + this.getCreatePulsarTopicTaskListener() + ", createPulsarSubscriptionTaskListener=" + this.getCreatePulsarSubscriptionTaskListener() + ", createSortConfigListener=" + this.getCreateSortConfigListener() + ", sinkResourceListener=" + this.getSinkResourceListener() + ")";
    }
}

