/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.stream;

import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.listener.StreamTaskListenerFactory;
import org.apache.inlong.manager.service.workflow.stream.listener.StreamCompleteProcessListener;
import org.apache.inlong.manager.service.workflow.stream.listener.StreamFailedProcessListener;
import org.apache.inlong.manager.service.workflow.stream.listener.StreamInitProcessListener;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateStreamWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(CreateStreamWorkflowDefinition.class);
    @Autowired
    private StreamInitProcessListener streamInitProcessListener;
    @Autowired
    private StreamFailedProcessListener streamFailedProcessListener;
    @Autowired
    private StreamCompleteProcessListener streamCompleteProcessListener;
    @Autowired
    private StreamTaskListenerFactory streamTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.addListener((ProcessEventListener)this.streamInitProcessListener);
        process.addListener((ProcessEventListener)this.streamFailedProcessListener);
        process.addListener((ProcessEventListener)this.streamCompleteProcessListener);
        process.setType("Stream Resource Creation");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(StreamResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask initMQTask = new ServiceTask();
        initMQTask.setName("initMQ");
        initMQTask.setDisplayName("Stream-InitMQ");
        initMQTask.addServiceTaskType(ServiceTaskType.INIT_MQ);
        initMQTask.addListenerProvider((ServiceTaskListenerProvider)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)initMQTask);
        ServiceTask initSinkTask = new ServiceTask();
        initSinkTask.setName("initSink");
        initSinkTask.setDisplayName("Stream-InitSink");
        initSinkTask.addServiceTaskType(ServiceTaskType.INIT_SINK);
        initSinkTask.addListenerProvider((ServiceTaskListenerProvider)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)initSinkTask);
        ServiceTask initSortTask = new ServiceTask();
        initSortTask.setName("initSort");
        initSortTask.setDisplayName("Stream-InitSort");
        initSortTask.addServiceTaskType(ServiceTaskType.INIT_SORT);
        initSortTask.addListenerProvider((ServiceTaskListenerProvider)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)initSortTask);
        ServiceTask initSourceTask = new ServiceTask();
        initSourceTask.setName("initSource");
        initSourceTask.setDisplayName("Stream-InitSource");
        initSourceTask.addServiceTaskType(ServiceTaskType.INIT_SOURCE);
        initSourceTask.addListenerProvider((ServiceTaskListenerProvider)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)initSourceTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)initMQTask);
        initMQTask.addNext((Element)initSinkTask);
        initSinkTask.addNext((Element)initSortTask);
        initSortTask.addNext((Element)initSourceTask);
        initSourceTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.CREATE_STREAM_RESOURCE;
    }
}

