/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.stream;

import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.listener.StreamTaskListenerFactory;
import org.apache.inlong.manager.service.workflow.stream.listener.StreamUpdateCompleteListener;
import org.apache.inlong.manager.service.workflow.stream.listener.StreamUpdateFailedListener;
import org.apache.inlong.manager.service.workflow.stream.listener.StreamUpdateListener;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestartStreamWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(RestartStreamWorkflowDefinition.class);
    @Autowired
    private StreamUpdateListener streamUpdateListener;
    @Autowired
    private StreamUpdateFailedListener streamUpdateFailedListener;
    @Autowired
    private StreamUpdateCompleteListener streamUpdateCompleteListener;
    @Autowired
    private StreamTaskListenerFactory streamTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.addListener((ProcessEventListener)this.streamUpdateListener);
        process.addListener((ProcessEventListener)this.streamUpdateCompleteListener);
        process.addListener((ProcessEventListener)this.streamUpdateFailedListener);
        process.setType("Stream Resource Restart");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(StreamResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask restartSortTask = new ServiceTask();
        restartSortTask.setName("restartSort");
        restartSortTask.setDisplayName("Stream-RestartSort");
        restartSortTask.addServiceTaskType(ServiceTaskType.RESTART_SORT);
        restartSortTask.addListenerProvider((ServiceTaskListenerProvider)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)restartSortTask);
        ServiceTask restartDataSourceTask = new ServiceTask();
        restartDataSourceTask.setName("restartSource");
        restartDataSourceTask.setDisplayName("Stream-RestartSource");
        restartDataSourceTask.addServiceTaskType(ServiceTaskType.RESTART_SOURCE);
        restartDataSourceTask.addListenerProvider((ServiceTaskListenerProvider)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)restartDataSourceTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)restartSortTask);
        restartSortTask.addNext((Element)restartDataSourceTask);
        restartDataSourceTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.RESTART_STREAM_RESOURCE;
    }
}

