/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.stream;

import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.service.workflow.ProcessName;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.listener.StreamTaskListenerFactory;
import org.apache.inlong.manager.service.workflow.stream.listener.StreamUpdateCompleteListener;
import org.apache.inlong.manager.service.workflow.stream.listener.StreamUpdateFailedListener;
import org.apache.inlong.manager.service.workflow.stream.listener.StreamUpdateListener;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ServiceTask;
import org.apache.inlong.manager.workflow.definition.ServiceTaskListenerProvider;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SuspendStreamWorkflowDefinition
implements WorkflowDefinition {
    private static final Logger log = LoggerFactory.getLogger(SuspendStreamWorkflowDefinition.class);
    @Autowired
    private StreamUpdateListener streamUpdateListener;
    @Autowired
    private StreamUpdateCompleteListener streamUpdateCompleteListener;
    @Autowired
    private StreamUpdateFailedListener streamUpdateFailedListener;
    @Autowired
    private StreamTaskListenerFactory streamTaskListenerFactory;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.addListener((ProcessEventListener)this.streamUpdateListener);
        process.addListener((ProcessEventListener)this.streamUpdateFailedListener);
        process.addListener((ProcessEventListener)this.streamUpdateCompleteListener);
        process.setType("Stream Resource Suspend");
        process.setName(this.getProcessName().name());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(StreamResourceProcessForm.class);
        process.setVersion(1);
        process.setHidden(Integer.valueOf(1));
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        ServiceTask stopDataSourceTask = new ServiceTask();
        stopDataSourceTask.setName("stopSource");
        stopDataSourceTask.setDisplayName("Stream-StopSource");
        stopDataSourceTask.addServiceTaskType(ServiceTaskType.STOP_SOURCE);
        stopDataSourceTask.addListenerProvider((ServiceTaskListenerProvider)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)stopDataSourceTask);
        ServiceTask stopSortTask = new ServiceTask();
        stopSortTask.setName("stopSort");
        stopSortTask.setDisplayName("Stream-StopSort");
        stopSortTask.addServiceTaskType(ServiceTaskType.STOP_SORT);
        stopSortTask.addListenerProvider((ServiceTaskListenerProvider)this.streamTaskListenerFactory);
        process.addTask((WorkflowTask)stopSortTask);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        startEvent.addNext((Element)stopDataSourceTask);
        stopDataSourceTask.addNext((Element)stopSortTask);
        stopSortTask.addNext((Element)endEvent);
        return process;
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.SUSPEND_STREAM_RESOURCE;
    }
}

