/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.stream.listener;

import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.service.core.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StreamUpdateListener
implements ProcessEventListener {
    @Autowired
    private InlongStreamService streamService;

    public ProcessEvent event() {
        return ProcessEvent.CREATE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        StreamResourceProcessForm form = (StreamResourceProcessForm)context.getProcessForm();
        InlongStreamInfo streamInfo = form.getStreamInfo();
        String operator = context.getOperator();
        GroupOperateType operateType = form.getGroupOperateType();
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        switch (operateType) {
            case SUSPEND: {
                this.streamService.updateStatus(groupId, streamId, StreamStatus.SUSPENDING.getCode(), operator);
                break;
            }
            case RESTART: {
                this.streamService.updateStatus(groupId, streamId, StreamStatus.RESTARTING.getCode(), operator);
                break;
            }
            case DELETE: {
                this.streamService.updateStatus(groupId, streamId, StreamStatus.DELETING.getCode(), operator);
                break;
            }
        }
        return ListenerResult.success();
    }

    public boolean async() {
        return false;
    }
}

