/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.dao.mapper.InlongClusterEntityMapper;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.service.cluster.InlongClusterOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractClusterOperator
implements InlongClusterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractClusterOperator.class);
    @Autowired
    protected InlongClusterEntityMapper clusterMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(ClusterRequest request, String operator) {
        InlongClusterEntity entity = (InlongClusterEntity)CommonBeanUtils.copyProperties((Object)request, InlongClusterEntity::new);
        this.setTargetEntity(request, entity);
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.clusterMapper.insert(entity);
        return entity.getId();
    }

    protected abstract void setTargetEntity(ClusterRequest var1, InlongClusterEntity var2);

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(ClusterRequest request, String operator) {
        InlongClusterEntity entity = (InlongClusterEntity)CommonBeanUtils.copyProperties((Object)request, InlongClusterEntity::new);
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        int rowCount = this.clusterMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("cluster has already updated with name={}, type={}, curVersion={}", new Object[]{request.getName(), request.getType(), request.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
    }
}

