/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractService<T>
implements AutoCloseable,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractService.class);
    @Value(value="${msg.to.db.batch.size:10}")
    private int batchSize = 10;
    @Value(value="${msg.to.db.queue.size:10000}")
    private int queueSize = 10000;
    @Value(value="${msg.to.db.core.pool.size:2}")
    private int corePoolSize = 2;
    @Value(value="${msg.to.db.max.pool.size:2}")
    private int maximumPoolSize = 2;
    @Value(value="${msg.to.db.queue.pool.size:10}")
    private int syncSendQueueSize = 10;
    private volatile boolean isClose = false;
    private LinkedBlockingQueue<T> dataQueue;
    private ThreadPoolExecutor pool;

    abstract boolean batchInsertEntities(List<T> var1);

    public boolean putData(T data) {
        if (this.dataQueue == null) {
            return false;
        }
        return this.dataQueue.offer(data);
    }

    @Override
    public void close() {
        this.isClose = true;
    }

    public void afterPropertiesSet() {
        this.dataQueue = new LinkedBlockingQueue(this.queueSize);
        this.pool = new ThreadPoolExecutor(this.corePoolSize, this.maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(this.syncSendQueueSize), Executors.defaultThreadFactory());
        for (int i = 0; i < this.corePoolSize; ++i) {
            this.pool.execute(new Task());
        }
    }

    class Task
    implements Runnable {
        Task() {
        }

        @Override
        public void run() {
            while (!AbstractService.this.isClose) {
                try {
                    ArrayList entryList = new ArrayList();
                    for (int count = 0; count < AbstractService.this.batchSize; ++count) {
                        Object data = AbstractService.this.dataQueue.poll(1L, TimeUnit.MILLISECONDS);
                        if (data == null) continue;
                        entryList.add(data);
                    }
                    if (!CollectionUtils.isNotEmpty(entryList)) continue;
                    AbstractService.this.batchInsertEntities(entryList);
                }
                catch (Exception e) {
                    LOGGER.error("batchInsertEntities has exception = {}", (Throwable)e);
                }
            }
        }
    }
}

