/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import org.apache.inlong.manager.common.enums.ConsumptionStatus;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.ConsumptionPulsarEntity;
import org.apache.inlong.manager.dao.mapper.ConsumptionPulsarEntityMapper;
import org.apache.inlong.manager.pojo.consumption.ConsumptionInfo;
import org.apache.inlong.manager.pojo.consumption.ConsumptionMqExtBase;
import org.apache.inlong.manager.pojo.consumption.ConsumptionPulsarInfo;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyConsumptionProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumptionProcessService {
    private static final Logger log = LoggerFactory.getLogger(ConsumptionProcessService.class);
    @Autowired
    private ConsumptionService consumptionService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private ConsumptionPulsarEntityMapper consumptionPulsarMapper;

    public WorkflowResult startProcess(Integer id, String operator) {
        ConsumptionInfo consumptionInfo = this.consumptionService.get(id);
        Preconditions.checkTrue((boolean)ConsumptionStatus.ALLOW_START_WORKFLOW_STATUS.contains(ConsumptionStatus.fromStatus((int)consumptionInfo.getStatus())), (String)"current status not allow start workflow");
        consumptionInfo.setStatus(Integer.valueOf(ConsumptionStatus.WAIT_APPROVE.getStatus()));
        boolean rowCount = this.consumptionService.update(consumptionInfo, operator);
        Preconditions.checkTrue((boolean)rowCount, (String)"update consumption failed");
        return this.workflowService.start(ProcessName.APPLY_CONSUMPTION_PROCESS, operator, (ProcessForm)this.genConsumptionProcessForm(consumptionInfo));
    }

    private ApplyConsumptionProcessForm genConsumptionProcessForm(ConsumptionInfo consumptionInfo) {
        ApplyConsumptionProcessForm form = new ApplyConsumptionProcessForm();
        Integer id = consumptionInfo.getId();
        String mqType = consumptionInfo.getMqType();
        if ("PULSAR".equals(mqType) || "TDMQ_PULSAR".equals(mqType)) {
            ConsumptionPulsarEntity consumptionPulsarEntity = this.consumptionPulsarMapper.selectByConsumptionId(id);
            ConsumptionPulsarInfo pulsarInfo = (ConsumptionPulsarInfo)CommonBeanUtils.copyProperties((Object)consumptionPulsarEntity, ConsumptionPulsarInfo::new);
            consumptionInfo.setMqExtInfo((ConsumptionMqExtBase)pulsarInfo);
        }
        form.setConsumptionInfo(consumptionInfo);
        return form;
    }
}

