/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.WorkflowEventLogEntity;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.workflow.EventLogRequest;
import org.apache.inlong.manager.pojo.workflow.EventLogResponse;
import org.apache.inlong.manager.service.core.WorkflowEventService;
import org.apache.inlong.manager.workflow.core.EventListenerService;
import org.apache.inlong.manager.workflow.core.WorkflowQueryService;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowEventServiceImpl
implements WorkflowEventService {
    @Autowired
    private WorkflowQueryService queryService;
    @Autowired
    private EventListenerService eventListenerService;

    @Override
    public EventLogResponse get(Integer id) {
        WorkflowEventLogEntity workflowEventLogEntity = this.queryService.getEventLog(id);
        return (EventLogResponse)CommonBeanUtils.copyProperties((Object)workflowEventLogEntity, EventLogResponse::new);
    }

    @Override
    public PageResult<EventLogResponse> list(EventLogRequest query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page page = (Page)this.queryService.listEventLog(query);
        List viewList = CommonBeanUtils.copyListProperties((List)page, EventLogResponse::new);
        return new PageResult(viewList, Long.valueOf(page.getTotal()), Integer.valueOf(page.getPageNum()), Integer.valueOf(page.getPageSize()));
    }

    @Override
    public void executeEventListener(Integer eventLogId) {
        this.eventListenerService.executeEventListener(eventLogId);
    }

    @Override
    public void executeProcessEventListener(Integer processId, String listenerName) {
        this.eventListenerService.executeProcessEventListener(processId, listenerName);
    }

    @Override
    public void executeTaskEventListener(Integer taskId, String listenerName) {
        this.eventListenerService.executeTaskEventListener(taskId, listenerName);
    }

    @Override
    public void triggerProcessEvent(Integer processId, ProcessEvent processEvent) {
        this.eventListenerService.triggerProcessEvent(processId, processEvent);
    }

    @Override
    public void triggerTaskEvent(Integer taskId, TaskEvent taskEvent) {
        this.eventListenerService.triggerTaskEvent(taskId, taskEvent);
    }
}

