/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarDTO;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarInfo;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarRequest;
import org.apache.inlong.manager.service.group.AbstractGroupOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InlongPulsarOperator
extends AbstractGroupOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongPulsarOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String mqType) {
        return this.getMQType().equals(mqType) || "TDMQ_PULSAR".equals(mqType);
    }

    @Override
    public String getMQType() {
        return "PULSAR";
    }

    @Override
    public InlongGroupInfo getFromEntity(InlongGroupEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        InlongPulsarInfo groupInfo = new InlongPulsarInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)groupInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            InlongPulsarDTO dto = InlongPulsarDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)groupInfo);
        }
        return groupInfo;
    }

    @Override
    protected void setTargetEntity(InlongGroupRequest request, InlongGroupEntity targetEntity) {
        InlongPulsarRequest pulsarRequest = (InlongPulsarRequest)request;
        Integer ackQuorum = pulsarRequest.getAckQuorum();
        Integer writeQuorum = pulsarRequest.getWriteQuorum();
        Preconditions.checkNotNull((Object)ackQuorum, (String)"Pulsar ackQuorum cannot be empty");
        Preconditions.checkNotNull((Object)writeQuorum, (String)"Pulsar writeQuorum cannot be empty");
        if (ackQuorum > writeQuorum) {
            throw new BusinessException(ErrorCodeEnum.GROUP_SAVE_FAILED, "Pulsar params must meet: ackQuorum <= writeQuorum");
        }
        pulsarRequest.setEnsemble(writeQuorum);
        CommonBeanUtils.copyProperties((Object)pulsarRequest, (Object)targetEntity, (boolean)true);
        try {
            InlongPulsarDTO dto = InlongPulsarDTO.getFromRequest((InlongPulsarRequest)pulsarRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
        LOGGER.info("success set entity for inlong group with Pulsar");
    }

    @Override
    public InlongGroupTopicInfo getTopic(InlongGroupInfo groupInfo) {
        InlongGroupTopicInfo topicInfo = super.getTopic(groupInfo);
        return topicInfo;
    }
}

