/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.tubemq.InlongTubeMQInfo;
import org.apache.inlong.manager.service.group.AbstractGroupOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InlongTubeOperator
extends AbstractGroupOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongTubeOperator.class);

    @Override
    public Boolean accept(String mqType) {
        return this.getMQType().equals(mqType);
    }

    @Override
    public String getMQType() {
        return "TUBEMQ";
    }

    public InlongTubeMQInfo getFromEntity(InlongGroupEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        InlongTubeMQInfo groupInfo = new InlongTubeMQInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)groupInfo);
        return groupInfo;
    }

    @Override
    protected void setTargetEntity(InlongGroupRequest request, InlongGroupEntity targetEntity) {
        LOGGER.info("do nothing for inlong group with TubeMQ");
    }

    @Override
    public InlongGroupTopicInfo getTopic(InlongGroupInfo groupInfo) {
        return super.getTopic(groupInfo);
    }
}

