/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.service.listener.queue.QueueResourceListener;
import org.apache.inlong.manager.service.listener.sink.SinkResourceListener;
import org.apache.inlong.manager.service.listener.sort.SortConfigListener;
import org.apache.inlong.manager.service.listener.source.SourceDeleteListener;
import org.apache.inlong.manager.service.listener.source.SourceRestartListener;
import org.apache.inlong.manager.service.listener.source.SourceStopListener;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.ServiceTaskType;
import org.apache.inlong.manager.workflow.definition.TaskListenerFactory;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.SourceOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.apache.inlong.manager.workflow.plugin.Plugin;
import org.apache.inlong.manager.workflow.plugin.PluginBinder;
import org.apache.inlong.manager.workflow.plugin.ProcessPlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupTaskListenerFactory
implements PluginBinder,
TaskListenerFactory {
    private List<SourceOperateListener> sourceOperateListeners;
    private List<QueueOperateListener> queueOperateListeners;
    private List<SortOperateListener> sortOperateListeners;
    @Autowired
    private SourceStopListener sourceStopListener;
    @Autowired
    private SourceRestartListener sourceRestartListener;
    @Autowired
    private SourceDeleteListener sourceDeleteListener;
    @Autowired
    private QueueResourceListener queueResourceListener;
    @Autowired
    private SinkResourceListener sinkResourceListener;
    @Autowired
    private SortConfigListener sortConfigListener;

    @PostConstruct
    public void init() {
        this.sourceOperateListeners = new LinkedList<SourceOperateListener>();
        this.sourceOperateListeners.add(this.sourceStopListener);
        this.sourceOperateListeners.add(this.sourceDeleteListener);
        this.sourceOperateListeners.add(this.sourceRestartListener);
        this.queueOperateListeners = new LinkedList<QueueOperateListener>();
        this.queueOperateListeners.add(this.queueResourceListener);
        this.sortOperateListeners = new LinkedList<SortOperateListener>();
        this.sortOperateListeners.add(this.sortConfigListener);
    }

    public void acceptPlugin(Plugin plugin) {
        List pluginSortOperateListeners;
        List pluginQueueOperateListeners;
        if (!(plugin instanceof ProcessPlugin)) {
            return;
        }
        ProcessPlugin processPlugin = (ProcessPlugin)plugin;
        List pluginSourceOperateListeners = processPlugin.createSourceOperateListeners();
        if (CollectionUtils.isNotEmpty((Collection)pluginSourceOperateListeners)) {
            this.sourceOperateListeners.addAll(processPlugin.createSourceOperateListeners());
        }
        if (CollectionUtils.isNotEmpty((Collection)(pluginQueueOperateListeners = processPlugin.createQueueOperateListeners()))) {
            this.queueOperateListeners.addAll(pluginQueueOperateListeners);
        }
        if (CollectionUtils.isNotEmpty((Collection)(pluginSortOperateListeners = processPlugin.createSortOperateListeners()))) {
            this.sortOperateListeners.addAll(pluginSortOperateListeners);
        }
    }

    public List<? extends TaskEventListener> get(WorkflowContext workflowContext, ServiceTaskType taskType) {
        switch (taskType) {
            case INIT_MQ: 
            case DELETE_MQ: {
                List<QueueOperateListener> queueOperateListeners = this.getQueueResourceListener(workflowContext);
                return Lists.newArrayList(queueOperateListeners);
            }
            case INIT_SORT: 
            case STOP_SORT: 
            case RESTART_SORT: 
            case DELETE_SORT: {
                List<SortOperateListener> sortOperateListeners = this.getSortOperateListener(workflowContext);
                return Lists.newArrayList(sortOperateListeners);
            }
            case INIT_SOURCE: 
            case STOP_SOURCE: 
            case RESTART_SOURCE: 
            case DELETE_SOURCE: {
                List<SourceOperateListener> sourceOperateListeners = this.getSourceOperateListener(workflowContext);
                return Lists.newArrayList(sourceOperateListeners);
            }
            case INIT_SINK: {
                return Collections.singletonList(this.sinkResourceListener);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported ServiceTaskType %s", taskType));
    }

    public void clearListeners() {
        this.sourceOperateListeners = new LinkedList<SourceOperateListener>();
        this.queueOperateListeners = new LinkedList<QueueOperateListener>();
        this.sortOperateListeners = new LinkedList<SortOperateListener>();
    }

    public List<SourceOperateListener> getSourceOperateListener(WorkflowContext context) {
        ArrayList<SourceOperateListener> listeners = new ArrayList<SourceOperateListener>();
        for (SourceOperateListener listener : this.sourceOperateListeners) {
            if (listener == null || !listener.accept(context)) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    public List<QueueOperateListener> getQueueResourceListener(WorkflowContext context) {
        ArrayList<QueueOperateListener> listeners = new ArrayList<QueueOperateListener>();
        for (QueueOperateListener listener : this.queueOperateListeners) {
            if (listener == null || !listener.accept(context)) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    public List<SortOperateListener> getSortOperateListener(WorkflowContext context) {
        ArrayList<SortOperateListener> listeners = new ArrayList<SortOperateListener>();
        for (SortOperateListener listener : this.sortOperateListeners) {
            if (listener == null || !listener.accept(context)) continue;
            listeners.add(listener);
        }
        return listeners;
    }

    public List<SourceOperateListener> getSourceOperateListeners() {
        return this.sourceOperateListeners;
    }

    public List<QueueOperateListener> getQueueOperateListeners() {
        return this.queueOperateListeners;
    }

    public List<SortOperateListener> getSortOperateListeners() {
        return this.sortOperateListeners;
    }

    public SourceStopListener getSourceStopListener() {
        return this.sourceStopListener;
    }

    public SourceRestartListener getSourceRestartListener() {
        return this.sourceRestartListener;
    }

    public SourceDeleteListener getSourceDeleteListener() {
        return this.sourceDeleteListener;
    }

    public QueueResourceListener getQueueResourceListener() {
        return this.queueResourceListener;
    }

    public SinkResourceListener getSinkResourceListener() {
        return this.sinkResourceListener;
    }

    public SortConfigListener getSortConfigListener() {
        return this.sortConfigListener;
    }

    public void setSourceOperateListeners(List<SourceOperateListener> sourceOperateListeners) {
        this.sourceOperateListeners = sourceOperateListeners;
    }

    public void setQueueOperateListeners(List<QueueOperateListener> queueOperateListeners) {
        this.queueOperateListeners = queueOperateListeners;
    }

    public void setSortOperateListeners(List<SortOperateListener> sortOperateListeners) {
        this.sortOperateListeners = sortOperateListeners;
    }

    public void setSourceStopListener(SourceStopListener sourceStopListener) {
        this.sourceStopListener = sourceStopListener;
    }

    public void setSourceRestartListener(SourceRestartListener sourceRestartListener) {
        this.sourceRestartListener = sourceRestartListener;
    }

    public void setSourceDeleteListener(SourceDeleteListener sourceDeleteListener) {
        this.sourceDeleteListener = sourceDeleteListener;
    }

    public void setQueueResourceListener(QueueResourceListener queueResourceListener) {
        this.queueResourceListener = queueResourceListener;
    }

    public void setSinkResourceListener(SinkResourceListener sinkResourceListener) {
        this.sinkResourceListener = sinkResourceListener;
    }

    public void setSortConfigListener(SortConfigListener sortConfigListener) {
        this.sortConfigListener = sortConfigListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroupTaskListenerFactory)) {
            return false;
        }
        GroupTaskListenerFactory other = (GroupTaskListenerFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SourceOperateListener> this$sourceOperateListeners = this.getSourceOperateListeners();
        List<SourceOperateListener> other$sourceOperateListeners = other.getSourceOperateListeners();
        if (this$sourceOperateListeners == null ? other$sourceOperateListeners != null : !((Object)this$sourceOperateListeners).equals(other$sourceOperateListeners)) {
            return false;
        }
        List<QueueOperateListener> this$queueOperateListeners = this.getQueueOperateListeners();
        List<QueueOperateListener> other$queueOperateListeners = other.getQueueOperateListeners();
        if (this$queueOperateListeners == null ? other$queueOperateListeners != null : !((Object)this$queueOperateListeners).equals(other$queueOperateListeners)) {
            return false;
        }
        List<SortOperateListener> this$sortOperateListeners = this.getSortOperateListeners();
        List<SortOperateListener> other$sortOperateListeners = other.getSortOperateListeners();
        if (this$sortOperateListeners == null ? other$sortOperateListeners != null : !((Object)this$sortOperateListeners).equals(other$sortOperateListeners)) {
            return false;
        }
        SourceStopListener this$sourceStopListener = this.getSourceStopListener();
        SourceStopListener other$sourceStopListener = other.getSourceStopListener();
        if (this$sourceStopListener == null ? other$sourceStopListener != null : !this$sourceStopListener.equals(other$sourceStopListener)) {
            return false;
        }
        SourceRestartListener this$sourceRestartListener = this.getSourceRestartListener();
        SourceRestartListener other$sourceRestartListener = other.getSourceRestartListener();
        if (this$sourceRestartListener == null ? other$sourceRestartListener != null : !this$sourceRestartListener.equals(other$sourceRestartListener)) {
            return false;
        }
        SourceDeleteListener this$sourceDeleteListener = this.getSourceDeleteListener();
        SourceDeleteListener other$sourceDeleteListener = other.getSourceDeleteListener();
        if (this$sourceDeleteListener == null ? other$sourceDeleteListener != null : !this$sourceDeleteListener.equals(other$sourceDeleteListener)) {
            return false;
        }
        QueueResourceListener this$queueResourceListener = this.getQueueResourceListener();
        QueueResourceListener other$queueResourceListener = other.getQueueResourceListener();
        if (this$queueResourceListener == null ? other$queueResourceListener != null : !this$queueResourceListener.equals(other$queueResourceListener)) {
            return false;
        }
        SinkResourceListener this$sinkResourceListener = this.getSinkResourceListener();
        SinkResourceListener other$sinkResourceListener = other.getSinkResourceListener();
        if (this$sinkResourceListener == null ? other$sinkResourceListener != null : !this$sinkResourceListener.equals(other$sinkResourceListener)) {
            return false;
        }
        SortConfigListener this$sortConfigListener = this.getSortConfigListener();
        SortConfigListener other$sortConfigListener = other.getSortConfigListener();
        return !(this$sortConfigListener == null ? other$sortConfigListener != null : !this$sortConfigListener.equals(other$sortConfigListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GroupTaskListenerFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SourceOperateListener> $sourceOperateListeners = this.getSourceOperateListeners();
        result = result * 59 + ($sourceOperateListeners == null ? 43 : ((Object)$sourceOperateListeners).hashCode());
        List<QueueOperateListener> $queueOperateListeners = this.getQueueOperateListeners();
        result = result * 59 + ($queueOperateListeners == null ? 43 : ((Object)$queueOperateListeners).hashCode());
        List<SortOperateListener> $sortOperateListeners = this.getSortOperateListeners();
        result = result * 59 + ($sortOperateListeners == null ? 43 : ((Object)$sortOperateListeners).hashCode());
        SourceStopListener $sourceStopListener = this.getSourceStopListener();
        result = result * 59 + ($sourceStopListener == null ? 43 : $sourceStopListener.hashCode());
        SourceRestartListener $sourceRestartListener = this.getSourceRestartListener();
        result = result * 59 + ($sourceRestartListener == null ? 43 : $sourceRestartListener.hashCode());
        SourceDeleteListener $sourceDeleteListener = this.getSourceDeleteListener();
        result = result * 59 + ($sourceDeleteListener == null ? 43 : $sourceDeleteListener.hashCode());
        QueueResourceListener $queueResourceListener = this.getQueueResourceListener();
        result = result * 59 + ($queueResourceListener == null ? 43 : $queueResourceListener.hashCode());
        SinkResourceListener $sinkResourceListener = this.getSinkResourceListener();
        result = result * 59 + ($sinkResourceListener == null ? 43 : $sinkResourceListener.hashCode());
        SortConfigListener $sortConfigListener = this.getSortConfigListener();
        result = result * 59 + ($sortConfigListener == null ? 43 : $sortConfigListener.hashCode());
        return result;
    }

    public String toString() {
        return "GroupTaskListenerFactory(sourceOperateListeners=" + this.getSourceOperateListeners() + ", queueOperateListeners=" + this.getQueueOperateListeners() + ", sortOperateListeners=" + this.getSortOperateListeners() + ", sourceStopListener=" + this.getSourceStopListener() + ", sourceRestartListener=" + this.getSourceRestartListener() + ", sourceDeleteListener=" + this.getSourceDeleteListener() + ", queueResourceListener=" + this.getQueueResourceListener() + ", sinkResourceListener=" + this.getSinkResourceListener() + ", sortConfigListener=" + this.getSortConfigListener() + ")";
    }
}

