/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.consumption;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ConsumptionStatus;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.dao.entity.ConsumptionEntity;
import org.apache.inlong.manager.dao.mapper.ConsumptionEntityMapper;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyConsumptionProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumptionCancelProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConsumptionCancelProcessListener.class);
    @Autowired
    private ConsumptionEntityMapper consumptionEntityMapper;

    @Autowired
    public ConsumptionCancelProcessListener(ConsumptionEntityMapper consumptionEntityMapper) {
        this.consumptionEntityMapper = consumptionEntityMapper;
    }

    public ProcessEvent event() {
        return ProcessEvent.CANCEL;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        ApplyConsumptionProcessForm processForm = (ApplyConsumptionProcessForm)context.getProcessForm();
        ConsumptionEntity update = this.consumptionEntityMapper.selectByPrimaryKey(processForm.getConsumptionInfo().getId());
        update.setStatus(Integer.valueOf(ConsumptionStatus.CANCELED.getStatus()));
        int rowCount = this.consumptionEntityMapper.updateByPrimaryKeySelective(update);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            log.error("consumption information has already updated, id={}, curVersion={}", (Object)update.getId(), (Object)update.getVersion());
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
        return ListenerResult.success((String)"Application process is cancelled");
    }
}

