/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.consumption;

import com.alibaba.druid.util.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.consumption.ConsumptionInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyConsumptionProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.ConsumptionApproveForm;
import org.apache.inlong.manager.service.core.ConsumptionService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConsumptionPassTaskListener
implements TaskEventListener {
    private static final Logger log = LoggerFactory.getLogger(ConsumptionPassTaskListener.class);
    @Autowired
    private ConsumptionService consumptionService;

    public TaskEvent event() {
        return TaskEvent.APPROVE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        ApplyConsumptionProcessForm form = (ApplyConsumptionProcessForm)context.getProcessForm();
        ConsumptionApproveForm approveForm = (ConsumptionApproveForm)context.getActionContext().getForm();
        ConsumptionInfo info = form.getConsumptionInfo();
        if (StringUtils.equals((String)approveForm.getConsumerGroup(), (String)info.getConsumerGroup())) {
            return ListenerResult.success((String)"The consumer group has not been modified");
        }
        boolean exist = this.consumptionService.isConsumerGroupExists(approveForm.getConsumerGroup(), info.getId());
        if (exist) {
            log.error("consumer group {} already exist", (Object)approveForm.getConsumerGroup());
            throw new BusinessException(ErrorCodeEnum.CONSUMER_GROUP_DUPLICATED);
        }
        return ListenerResult.success((String)("Consumer group from " + info.getConsumerGroup() + " change to " + approveForm.getConsumerGroup()));
    }
}

