/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group;

import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.StreamStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitGroupFailedListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(InitGroupFailedListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;

    public ProcessEvent event() {
        return ProcessEvent.FAIL;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to execute InitGroupFailedListener for groupId={}", (Object)groupId);
        String operator = context.getOperator();
        this.groupService.updateStatus(groupId, GroupStatus.CONFIG_FAILED.getCode(), operator);
        this.groupService.update(form.getGroupInfo().genRequest(), operator);
        this.streamService.updateStatus(groupId, null, StreamStatus.CONFIG_FAILED.getCode(), operator);
        log.info("success to execute InitGroupFailedListener for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }
}

