/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group;

import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateGroupListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(UpdateGroupListener.class);
    @Autowired
    private InlongGroupService groupService;

    public ProcessEvent event() {
        return ProcessEvent.CREATE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to execute UpdateGroupListener for groupId={}", (Object)groupId);
        InlongGroupInfo groupInfo = form.getGroupInfo();
        if (groupInfo == null) {
            throw new BusinessException("InlongGroupInfo cannot be null for update group process");
        }
        GroupOperateType operateType = form.getGroupOperateType();
        String operator = context.getOperator();
        switch (operateType) {
            case SUSPEND: {
                this.groupService.updateStatus(groupId, GroupStatus.SUSPENDING.getCode(), operator);
                break;
            }
            case RESTART: {
                this.groupService.updateStatus(groupId, GroupStatus.RESTARTING.getCode(), operator);
                break;
            }
            case DELETE: {
                this.groupService.updateStatus(groupId, GroupStatus.DELETING.getCode(), operator);
                break;
            }
        }
        log.info("success to execute UpdateGroupListener for groupId={}, operateType={}", (Object)groupId, (Object)operateType);
        return ListenerResult.success();
    }
}

