/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group.apply;

import java.util.List;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyGroupProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApproveApplyProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(ApproveApplyProcessListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private WorkflowService workflowService;

    public ProcessEvent event() {
        return ProcessEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        ApplyGroupProcessForm form = (ApplyGroupProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to execute ApproveApplyProcessListener for groupId={}", (Object)groupId);
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        GroupResourceProcessForm processForm = new GroupResourceProcessForm();
        processForm.setGroupInfo(groupInfo);
        String username = context.getOperator();
        List<InlongStreamInfo> streamList = this.streamService.list(groupId);
        processForm.setStreamInfos(streamList);
        EXECUTOR_SERVICE.execute(() -> this.workflowService.start(ProcessName.CREATE_GROUP_RESOURCE, username, (ProcessForm)processForm));
        log.info("success to execute ApproveApplyProcessListener for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }
}

