/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.group.apply;

import java.util.Objects;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyGroupProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.process.ProcessEvent;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RejectApplyProcessListener
implements ProcessEventListener {
    private static final Logger log = LoggerFactory.getLogger(RejectApplyProcessListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private InlongGroupEntityMapper groupMapper;

    public ProcessEvent event() {
        return ProcessEvent.REJECT;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        ApplyGroupProcessForm form = (ApplyGroupProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to execute RejectApplyProcessListener for groupId={}", (Object)groupId);
        InlongGroupEntity entity = this.groupMapper.selectByGroupId(groupId);
        if (entity == null) {
            throw new WorkflowListenerException("inlong group not found with groupId=" + groupId);
        }
        if (!Objects.equals(GroupStatus.TO_BE_APPROVAL.getCode(), entity.getStatus())) {
            throw new WorkflowListenerException("current status was not allowed to reject inlong group");
        }
        String username = context.getOperator();
        this.groupService.updateStatus(groupId, GroupStatus.APPROVE_REJECTED.getCode(), username);
        return ListenerResult.success();
    }
}

