/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.queue;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperator;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperatorFactory;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.QueueOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueueResourceListener
implements QueueOperateListener {
    private static final Logger log = LoggerFactory.getLogger(QueueResourceListener.class);
    @Autowired
    private InlongGroupService groupService;
    @Autowired
    private QueueResourceOperatorFactory queueOperatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        if (!this.isGroupProcessForm(context)) {
            return false;
        }
        GroupResourceProcessForm processForm = (GroupResourceProcessForm)context.getProcessForm();
        return InlongConstants.STANDARD_MODE.equals(processForm.getGroupInfo().getLightweight());
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm groupProcessForm = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = groupProcessForm.getInlongGroupId();
        InlongGroupInfo groupInfo = this.groupService.get(groupId);
        if (groupInfo == null) {
            String msg = "inlong group not found with groupId=" + groupId;
            log.error(msg);
            throw new WorkflowListenerException(msg);
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(groupInfo.getEnableCreateResource())) {
            log.warn("skip to execute QueueResourceListener as disable create resource for groupId={}", (Object)groupId);
            return ListenerResult.success((String)"skip - disable create resource");
        }
        QueueResourceOperator queueOperator = this.queueOperatorFactory.getInstance(groupInfo.getMqType());
        GroupOperateType operateType = groupProcessForm.getGroupOperateType();
        String operator = context.getOperator();
        switch (operateType) {
            case INIT: {
                queueOperator.createQueueForGroup(groupInfo, operator);
                break;
            }
            case DELETE: {
                queueOperator.deleteQueueForGroup(groupInfo, operator);
                break;
            }
            default: {
                log.warn("unsupported operate={} for inlong group", (Object)operateType);
            }
        }
        log.info("success to execute QueueResourceListener for groupId={}, operateType={}", (Object)groupId, (Object)operateType);
        return ListenerResult.success((String)"success");
    }
}

