/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperatorFactory;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SinkOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SinkResourceListener
implements SinkOperateListener {
    private static final Logger log = LoggerFactory.getLogger(SinkResourceListener.class);
    @Autowired
    private StreamSinkEntityMapper sinkMapper;
    @Autowired
    private SinkResourceOperatorFactory sinkOperatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) {
        List configList;
        List needCreateList;
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        log.info("begin to create sink resources for groupId={}", (Object)groupId);
        List<Object> streamIdList = new ArrayList();
        List streamList = form.getStreamInfos();
        if (CollectionUtils.isNotEmpty((Collection)streamList)) {
            streamIdList = streamList.stream().map(InlongStreamInfo::getInlongStreamId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(needCreateList = (configList = this.sinkMapper.selectAllConfig(groupId, streamIdList)).stream().filter(sinkInfo -> InlongConstants.ENABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())).collect(Collectors.toList()))) {
            log.info("all sink resources have been created for group [" + groupId + "] and stream " + streamIdList);
            return ListenerResult.success();
        }
        for (SinkInfo sinkInfo2 : needCreateList) {
            SinkResourceOperator resourceOperator = this.sinkOperatorFactory.getInstance(sinkInfo2.getSinkType());
            resourceOperator.createSinkResource(sinkInfo2);
        }
        log.info("success to create sink resources for group [" + groupId + "] and stream " + streamIdList);
        return ListenerResult.success();
    }
}

