/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.sort;

import java.util.List;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.service.resource.sort.SortConfigOperator;
import org.apache.inlong.manager.service.resource.sort.SortConfigOperatorFactory;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SortConfigListener
implements SortOperateListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortConfigListener.class);
    @Autowired
    private SortConfigOperatorFactory operatorFactory;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext context) {
        ProcessForm processForm = context.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (processForm instanceof GroupResourceProcessForm) {
            GroupResourceProcessForm groupResourceForm = (GroupResourceProcessForm)processForm;
            InlongGroupInfo groupInfo = groupResourceForm.getGroupInfo();
            boolean enable = InlongConstants.DISABLE_ZK.equals(groupInfo.getEnableZookeeper());
            LOGGER.info("zookeeper disabled was [{}] for groupId [{}]", (Object)enable, (Object)groupId);
            return enable;
        }
        if (processForm instanceof StreamResourceProcessForm) {
            StreamResourceProcessForm streamResourceForm = (StreamResourceProcessForm)processForm;
            InlongGroupInfo groupInfo = streamResourceForm.getGroupInfo();
            InlongStreamInfo streamInfo = streamResourceForm.getStreamInfo();
            boolean enable = InlongConstants.DISABLE_ZK.equals(groupInfo.getEnableZookeeper());
            LOGGER.info("zookeeper disabled was [{}] for groupId [{}] and streamId [{}] ", new Object[]{enable, groupId, streamInfo.getInlongStreamId()});
            return enable;
        }
        LOGGER.info("zk disabled for groupId [{}]", (Object)groupId);
        return false;
    }

    public ListenerResult listen(WorkflowContext context) throws WorkflowListenerException {
        GroupResourceProcessForm form = (GroupResourceProcessForm)context.getProcessForm();
        String groupId = form.getInlongGroupId();
        LOGGER.info("begin to build sort config for groupId={}", (Object)groupId);
        GroupOperateType operateType = form.getGroupOperateType();
        if (operateType == GroupOperateType.SUSPEND || operateType == GroupOperateType.DELETE) {
            LOGGER.info("not build sort config for groupId={}, as the group operate type={}", (Object)groupId, (Object)operateType);
            return ListenerResult.success();
        }
        InlongGroupInfo groupInfo = form.getGroupInfo();
        List streamInfos = form.getStreamInfos();
        int sinkCount = streamInfos.stream().map(stream -> stream.getSinkList() == null ? 0 : stream.getSinkList().size()).reduce(0, Integer::sum);
        if (sinkCount == 0) {
            LOGGER.warn("not build sort config for groupId={}, as not found any sink", (Object)groupId);
            return ListenerResult.success();
        }
        try {
            SortConfigOperator operator = this.operatorFactory.getInstance(groupInfo.getEnableZookeeper());
            operator.buildConfig(groupInfo, streamInfos, false);
        }
        catch (Exception e) {
            String msg = String.format("failed to build sort config for groupId=%s, ", groupId);
            LOGGER.error(msg + "streamInfos=" + streamInfos, (Throwable)e);
            throw new WorkflowListenerException(msg + e.getMessage());
        }
        LOGGER.info("success to build sort config for groupId={}", (Object)groupId);
        return ListenerResult.success();
    }
}

