/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.listener.source;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.SourceStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.kafka.KafkaSource;
import org.apache.inlong.manager.pojo.source.kafka.KafkaSourceRequest;
import org.apache.inlong.manager.pojo.source.mysql.MySQLBinlogSource;
import org.apache.inlong.manager.pojo.source.mysql.MySQLBinlogSourceRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.service.source.StreamSourceService;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SourceOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractSourceOperateListener
implements SourceOperateListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractSourceOperateListener.class);
    @Autowired
    protected InlongStreamService streamService;
    @Autowired
    protected StreamSourceService streamSourceService;

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        log.info("operate stream source for context={}", (Object)context);
        InlongGroupInfo groupInfo = this.getGroupInfo(context.getProcessForm());
        String groupId = groupInfo.getInlongGroupId();
        List<InlongStreamBriefInfo> streamResponses = this.streamService.listBriefWithSink(groupId);
        ArrayList unOperatedSources = Lists.newArrayList();
        streamResponses.forEach(stream -> this.operateStreamSources(groupId, stream.getInlongStreamId(), context.getOperator(), unOperatedSources));
        if (CollectionUtils.isNotEmpty((Collection)unOperatedSources)) {
            GroupOperateType groupOperateType = this.getOperateType(context.getProcessForm());
            StringBuilder builder = new StringBuilder("Unsupported operate ").append(groupOperateType).append(" for (");
            unOperatedSources.forEach(source -> builder.append(" ").append(source.getSourceName()).append(" "));
            String errMsg = builder.append(")").toString();
            throw new WorkflowListenerException(errMsg);
        }
        return ListenerResult.success();
    }

    protected void operateStreamSources(String groupId, String streamId, String operator, List<StreamSource> unOperatedSources) {
        List<StreamSource> sources = this.streamSourceService.listSource(groupId, streamId);
        sources.forEach(source -> {
            boolean checkIfOp = this.checkIfOp((StreamSource)source, unOperatedSources);
            if (checkIfOp) {
                SourceRequest sourceRequest = this.createSourceRequest((StreamSource)source);
                this.operateStreamSource(sourceRequest, operator);
            }
        });
    }

    public boolean checkIfOp(StreamSource streamSource, List<StreamSource> unOperatedSources) {
        for (int retry = 0; retry < 60; ++retry) {
            int status = streamSource.getStatus();
            SourceStatus sourceStatus = SourceStatus.forCode((int)status);
            if (sourceStatus == SourceStatus.SOURCE_NORMAL || sourceStatus == SourceStatus.SOURCE_FROZEN) {
                return true;
            }
            if (sourceStatus == SourceStatus.SOURCE_FAILED || sourceStatus == SourceStatus.SOURCE_DISABLE) {
                return false;
            }
            log.warn("stream source={} cannot be operated for status={}", (Object)streamSource, (Object)sourceStatus);
            TimeUnit.SECONDS.sleep(5L);
            streamSource = this.streamSourceService.get(streamSource.getId());
        }
        SourceStatus sourceStatus = SourceStatus.forCode((int)streamSource.getStatus());
        if (sourceStatus != SourceStatus.SOURCE_NORMAL && sourceStatus != SourceStatus.SOURCE_FROZEN && sourceStatus != SourceStatus.SOURCE_DISABLE && sourceStatus != SourceStatus.SOURCE_FAILED) {
            log.error("stream source ={} cannot be operated for status={}", (Object)streamSource, (Object)sourceStatus);
            unOperatedSources.add(streamSource);
        }
        return false;
    }

    public SourceRequest createSourceRequest(StreamSource streamSource) {
        String sourceType;
        switch (sourceType = streamSource.getSourceType()) {
            case "MYSQL_BINLOG": {
                return (SourceRequest)CommonBeanUtils.copyProperties((Object)((MySQLBinlogSource)streamSource), MySQLBinlogSourceRequest::new);
            }
            case "KAFKA": {
                return (SourceRequest)CommonBeanUtils.copyProperties((Object)((KafkaSource)streamSource), KafkaSourceRequest::new);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported type=%s for SourceOperateListener", sourceType));
    }

    public abstract void operateStreamSource(SourceRequest var1, String var2);

    private GroupOperateType getOperateType(ProcessForm processForm) {
        if (processForm instanceof GroupResourceProcessForm) {
            return ((GroupResourceProcessForm)processForm).getGroupOperateType();
        }
        log.error("illegal process form {} to get inlong group info", (Object)processForm.getFormName());
        throw new RuntimeException("Unsupported ProcessForm " + processForm.getFormName());
    }

    private InlongGroupInfo getGroupInfo(ProcessForm processForm) {
        if (processForm instanceof GroupResourceProcessForm) {
            GroupResourceProcessForm groupResourceProcessForm = (GroupResourceProcessForm)processForm;
            return groupResourceProcessForm.getGroupInfo();
        }
        log.error("illegal process form {} to get inlong group info", (Object)processForm.getFormName());
        throw new RuntimeException("Unsupported ProcessForm " + processForm.getFormName());
    }
}

