/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node;

import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.dao.mapper.DataNodeEntityMapper;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.service.node.DataNodeOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractDataNodeOperator
implements DataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataNodeOperator.class);
    @Autowired
    protected DataNodeEntityMapper dataNodeEntityMapper;

    @Override
    @Transactional(rollbackFor={Throwable.class})
    public Integer saveOpt(DataNodeRequest request, String operator) {
        DataNodeEntity entity = (DataNodeEntity)CommonBeanUtils.copyProperties((Object)request, DataNodeEntity::new);
        this.setTargetEntity(request, entity);
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.dataNodeEntityMapper.insert(entity);
        return entity.getId();
    }

    protected abstract void setTargetEntity(DataNodeRequest var1, DataNodeEntity var2);

    @Override
    @Transactional(rollbackFor={Throwable.class}, isolation=Isolation.REPEATABLE_READ)
    public void updateOpt(DataNodeRequest request, String operator) {
        DataNodeEntity entity = (DataNodeEntity)CommonBeanUtils.copyProperties((Object)request, DataNodeEntity::new);
        this.setTargetEntity(request, entity);
        entity.setModifier(operator);
        int rowCount = this.dataNodeEntityMapper.updateByIdSelective(entity);
        if (rowCount != InlongConstants.AFFECTED_ONE_ROW) {
            LOGGER.error("data node has already updated with name={}, type={}, curVersion={}", new Object[]{request.getName(), request.getType(), request.getVersion()});
            throw new BusinessException(ErrorCodeEnum.CONFIG_EXPIRED);
        }
    }
}

