/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.ck;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseColumnInfo;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseSinkDTO;
import org.apache.inlong.manager.pojo.sink.ck.ClickHouseTableInfo;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.ck.ClickHouseJdbcUtils;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClickHouseResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClickHouseResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper clickHouseFieldMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "CLICKHOUSE".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        if (sinkInfo == null) {
            LOGGER.warn("sink info was null, skip to create resource");
            return;
        }
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createTable(sinkInfo);
    }

    private void createTable(SinkInfo sinkInfo) {
        LOGGER.info("begin to create clickhouse table for sinkId={}", (Object)sinkInfo.getId());
        List fieldList = this.clickHouseFieldMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            LOGGER.warn("no clickhouse fields found, skip to create table for sinkId={}", (Object)sinkInfo.getId());
        }
        ArrayList<ClickHouseColumnInfo> columnList = new ArrayList<ClickHouseColumnInfo>();
        for (StreamSinkFieldEntity field : fieldList) {
            ClickHouseColumnInfo columnInfo = new ClickHouseColumnInfo();
            columnInfo.setName(field.getFieldName());
            columnInfo.setType(field.getFieldType());
            columnInfo.setDesc(field.getFieldComment());
            columnList.add(columnInfo);
        }
        try {
            ClickHouseSinkDTO ckInfo = ClickHouseSinkDTO.getFromJson((String)sinkInfo.getExtParams());
            ClickHouseTableInfo tableInfo = ClickHouseSinkDTO.getClickHouseTableInfo((ClickHouseSinkDTO)ckInfo, columnList);
            String url = ckInfo.getJdbcUrl();
            String user = ckInfo.getUsername();
            String password = ckInfo.getPassword();
            String dbName = tableInfo.getDbName();
            String tableName = tableInfo.getTableName();
            ClickHouseJdbcUtils.createDb(url, user, password, dbName);
            List<String> tables = ClickHouseJdbcUtils.getTables(url, user, password, dbName);
            boolean tableExists = tables.contains(tableName);
            if (!tableExists) {
                ClickHouseJdbcUtils.createTable(url, user, password, tableInfo);
            } else {
                List<ClickHouseColumnInfo> existColumns = ClickHouseJdbcUtils.getColumns(url, user, password, dbName, tableName);
                List<ClickHouseColumnInfo> needAddColumns = tableInfo.getColumns().stream().skip(existColumns.size()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(needAddColumns)) {
                    ClickHouseJdbcUtils.addColumns(url, user, password, dbName, tableName, needAddColumns);
                }
            }
            String info = "success to create clickhouse resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e) {
            String errMsg = "create clickhouse table failed: " + e.getMessage();
            LOGGER.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
        LOGGER.info("success create ClickHouse table for data sind [" + sinkInfo.getId() + "]");
    }
}

