/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.mysql;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLColumnInfo;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLTableInfo;
import org.apache.inlong.manager.service.resource.sink.mysql.MySQLSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLJdbcUtils {
    private static final String MYSQL_JDBC_PREFIX = "jdbc:mysql";
    private static final String MYSQL_DRIVER_CLASS = "com.mysql.cj.jdbc.Driver";
    private static final Logger LOG = LoggerFactory.getLogger(MySQLJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        Connection conn;
        if (StringUtils.isBlank((CharSequence)url) || !url.startsWith(MYSQL_JDBC_PREFIX)) {
            throw new Exception("MySQL server URL was invalid, it should start with jdbc:mysql");
        }
        try {
            Class.forName(MYSQL_DRIVER_CLASS);
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            String errorMsg = "get MySQL connection error, please check MySQL JDBC url, username or password!";
            LOG.error("get MySQL connection error, please check MySQL JDBC url, username or password!", (Throwable)e);
            throw new Exception("get MySQL connection error, please check MySQL JDBC url, username or password! other error msg: " + e.getMessage());
        }
        if (Objects.isNull(conn)) {
            throw new Exception("get MySQL connection failed, please contact administrator.");
        }
        LOG.info("get MySQL connection success, url={}", (Object)url);
        return conn;
    }

    public static void executeSql(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            LOG.info("execute sql [{}] success", (Object)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlBatch(Connection conn, List<String> sqls) throws Exception {
        conn.setAutoCommit(false);
        try (Statement stmt = conn.createStatement();){
            for (String entry : sqls) {
                stmt.execute(entry);
            }
            conn.commit();
            LOG.info("execute sql [{}] success", sqls);
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    public static void createDb(Connection conn, String dbName) throws Exception {
        if (!MySQLJdbcUtils.checkDbExist(conn, dbName)) {
            String createDbSql = MySQLSqlBuilder.buildCreateDbSql(dbName);
            MySQLJdbcUtils.executeSql(conn, createDbSql);
            LOG.info("execute sql [{}] success", (Object)createDbSql);
        } else {
            LOG.info("The database [{}] are exists", (Object)dbName);
        }
    }

    public static boolean checkDbExist(Connection conn, String dbName) throws Exception {
        boolean result = false;
        String checkDbSql = MySQLSqlBuilder.getCheckDatabase(dbName);
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkDbSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                boolean bl = true;
                return bl;
            }
        }
        LOG.info("check db exist for db={}, result={}", (Object)dbName, (Object)result);
        return result;
    }

    public static void createTable(Connection conn, MySQLTableInfo tableInfo) throws Exception {
        if (MySQLJdbcUtils.checkTablesExist(conn, tableInfo.getDbName(), tableInfo.getTableName())) {
            LOG.info("The table [{}] are exists", (Object)tableInfo.getTableName());
        } else {
            String createTableSql = MySQLSqlBuilder.buildCreateTableSql(tableInfo);
            MySQLJdbcUtils.executeSql(conn, createTableSql);
            LOG.info("execute sql [{}] success", (Object)createTableSql);
        }
    }

    public static boolean checkTablesExist(Connection conn, String dbName, String tableName) throws Exception {
        boolean result = false;
        String checkTableSql = MySQLSqlBuilder.getCheckTable(dbName, tableName);
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkTableSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                result = true;
            }
        }
        LOG.info("check table exist for db={} table={}, result={}", new Object[]{dbName, tableName, result});
        return result;
    }

    public static boolean checkColumnExist(Connection conn, String dbName, String tableName, String column) throws Exception {
        boolean result = false;
        String checkTableSql = MySQLSqlBuilder.getCheckColumn(dbName, tableName, column);
        try (Statement stmt = conn.createStatement();
             ResultSet resultSet = stmt.executeQuery(checkTableSql);){
            if (Objects.nonNull(resultSet) && resultSet.next()) {
                result = true;
            }
        }
        LOG.info("check column exist for db={} table={}, result={} column={}", new Object[]{dbName, tableName, result, column});
        return result;
    }

    public static List<MySQLColumnInfo> getColumns(Connection conn, String dbName, String tableName) throws Exception {
        String querySql = MySQLSqlBuilder.buildDescTableSql(dbName, tableName);
        ArrayList<MySQLColumnInfo> columnList = new ArrayList<MySQLColumnInfo>();
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(querySql);){
            if (Objects.nonNull(rs)) {
                while (rs.next()) {
                    MySQLColumnInfo columnInfo = new MySQLColumnInfo(rs.getString(1), rs.getString(2), rs.getString(3));
                    columnList.add(columnInfo);
                }
            }
        }
        return columnList;
    }

    public static void addColumns(Connection conn, String dbName, String tableName, List<MySQLColumnInfo> columns) throws Exception {
        ArrayList columnInfos = Lists.newArrayList();
        for (MySQLColumnInfo columnInfo : columns) {
            if (MySQLJdbcUtils.checkColumnExist(conn, dbName, tableName, columnInfo.getName())) continue;
            columnInfos.add(columnInfo);
        }
        List<String> addColumnSql = MySQLSqlBuilder.buildAddColumnsSql(dbName, tableName, columnInfos);
        MySQLJdbcUtils.executeSqlBatch(conn, addColumnSql);
    }
}

