/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.sink.sqlserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.pojo.sink.SinkField;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerSink;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerSinkDTO;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerSinkRequest;
import org.apache.inlong.manager.service.sink.AbstractSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLServerSinkOperator
extends AbstractSinkOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLServerSinkOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String sinkType) {
        return "SQLSERVER".equals(sinkType);
    }

    @Override
    protected String getSinkType() {
        return "SQLSERVER";
    }

    @Override
    protected void setTargetEntity(SinkRequest request, StreamSinkEntity targetEntity) {
        Preconditions.checkTrue((boolean)this.getSinkType().equals(request.getSinkType()), (String)(ErrorCodeEnum.SINK_TYPE_NOT_SUPPORT.getMessage() + ": " + this.getSinkType()));
        SQLServerSinkRequest sinkRequest = (SQLServerSinkRequest)request;
        try {
            SQLServerSinkDTO dto = SQLServerSinkDTO.getFromRequest((SQLServerSinkRequest)sinkRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            LOGGER.error("parsing json string to sink info failed", (Throwable)e);
            throw new BusinessException(ErrorCodeEnum.SINK_SAVE_FAILED.getMessage());
        }
    }

    @Override
    public StreamSink getFromEntity(StreamSinkEntity entity) {
        SQLServerSink sink = new SQLServerSink();
        if (entity == null) {
            return sink;
        }
        SQLServerSinkDTO dto = SQLServerSinkDTO.getFromJson((String)entity.getExtParams());
        CommonBeanUtils.copyProperties((Object)entity, (Object)sink, (boolean)true);
        CommonBeanUtils.copyProperties((Object)dto, (Object)sink, (boolean)true);
        List<SinkField> sinkFields = super.getSinkFields(entity.getId());
        sink.setSinkFieldList(sinkFields);
        return sink;
    }
}

