/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.common.enums.TaskStatus;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.WorkflowProcessEntity;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.workflow.EventLogRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessCountRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessCountResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessDetailResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessResponse;
import org.apache.inlong.manager.pojo.workflow.TaskCountRequest;
import org.apache.inlong.manager.pojo.workflow.TaskCountResponse;
import org.apache.inlong.manager.pojo.workflow.TaskExecuteLog;
import org.apache.inlong.manager.pojo.workflow.TaskLogRequest;
import org.apache.inlong.manager.pojo.workflow.TaskRequest;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.WorkflowExecuteLog;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.TaskForm;
import org.apache.inlong.manager.service.workflow.WorkflowService;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.core.ProcessDefinitionService;
import org.apache.inlong.manager.workflow.core.ProcessService;
import org.apache.inlong.manager.workflow.core.TaskService;
import org.apache.inlong.manager.workflow.core.WorkflowQueryService;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.util.WorkflowUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WorkflowServiceImpl
implements WorkflowService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    @Autowired
    private WorkflowQueryService queryService;
    @Autowired
    private ProcessDefinitionService processDefService;
    @Autowired
    private ProcessService processService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public WorkflowResult start(ProcessName process, String operator, ProcessForm form) {
        WorkflowContext context = this.processService.start(process.name(), operator, form);
        return WorkflowUtils.getResult((WorkflowContext)context);
    }

    @Override
    public WorkflowResult continueProcess(Integer processId, String operator, String remark) {
        WorkflowContext context = this.processService.continueProcess(processId, operator, remark);
        return WorkflowUtils.getResult((WorkflowContext)context);
    }

    @Override
    public WorkflowResult cancel(Integer processId, String operator, String remark) {
        WorkflowContext context = this.processService.cancel(processId, operator, remark);
        return WorkflowUtils.getResult((WorkflowContext)context);
    }

    @Override
    public WorkflowResult approve(Integer taskId, String remark, TaskForm form, String operator) {
        WorkflowContext context = this.taskService.approve(taskId, remark, form, operator);
        return WorkflowUtils.getResult((WorkflowContext)context);
    }

    @Override
    public WorkflowResult reject(Integer taskId, String remark, String operator) {
        WorkflowContext context = this.taskService.reject(taskId, remark, operator);
        return WorkflowUtils.getResult((WorkflowContext)context);
    }

    @Override
    public WorkflowResult transfer(Integer taskId, String remark, List<String> to, String operator) {
        WorkflowContext context = this.taskService.transfer(taskId, remark, to, operator);
        return WorkflowUtils.getResult((WorkflowContext)context);
    }

    @Override
    public WorkflowResult complete(Integer taskId, String remark, String operator) {
        WorkflowContext context = this.taskService.complete(taskId, remark, operator);
        return WorkflowUtils.getResult((WorkflowContext)context);
    }

    @Override
    public ProcessDetailResponse detail(Integer processId, Integer taskId, String operator) {
        return this.queryService.detail(processId, taskId, operator);
    }

    @Override
    public PageResult<ProcessResponse> listProcess(ProcessRequest query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page result = (Page)this.queryService.listProcessEntity(query);
        PageInfo pageInfo = result.toPageInfo(entity -> {
            ProcessResponse response = WorkflowUtils.getProcessResponse((WorkflowProcessEntity)entity);
            if (query.getIncludeShowInList().booleanValue()) {
                response.setShowInList(this.getShowInList((WorkflowProcessEntity)entity));
            }
            return response;
        });
        PageResult pageResult = new PageResult(pageInfo.getList(), Long.valueOf(pageInfo.getTotal()), Integer.valueOf(pageInfo.getPageNum()), Integer.valueOf(pageInfo.getPageSize()));
        if (query.getIncludeCurrentTask().booleanValue()) {
            TaskRequest taskQuery = TaskRequest.builder().type(UserTask.class.getSimpleName()).statusSet(Collections.singleton(TaskStatus.PENDING)).build();
            PageHelper.startPage((int)0, (int)100);
            pageResult.getList().forEach(this.addCurrentTask(taskQuery));
        }
        return pageResult;
    }

    @Override
    public PageResult<TaskResponse> listTask(TaskRequest query) {
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page result = (Page)this.queryService.listTaskEntity(query);
        PageInfo pageInfo = result.toPageInfo(WorkflowUtils::getTaskResponse);
        this.addShowInListForEachTask(pageInfo.getList());
        return new PageResult(pageInfo.getList(), Long.valueOf(pageInfo.getTotal()), Integer.valueOf(pageInfo.getPageNum()), Integer.valueOf(pageInfo.getPageSize()));
    }

    @Override
    public ProcessCountResponse countProcess(ProcessCountRequest query) {
        return this.queryService.countProcess(query);
    }

    @Override
    public TaskCountResponse countTask(TaskCountRequest query) {
        return this.queryService.countTask(query);
    }

    @Override
    public PageResult<WorkflowExecuteLog> listTaskLogs(TaskLogRequest query) {
        Preconditions.checkNotNull((Object)query, (String)"task execute log query params cannot be null");
        String groupId = query.getInlongGroupId();
        List processNameList = query.getProcessNames();
        Preconditions.checkNotEmpty((String)groupId, (String)"inlong group id cannot be null");
        Preconditions.checkNotEmpty((Collection)processNameList, (String)"process name list cannot be null");
        ProcessRequest processRequest = new ProcessRequest();
        processRequest.setInlongGroupId(groupId);
        processRequest.setNameList(processNameList);
        processRequest.setHidden(Integer.valueOf(1));
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page entityPage = (Page)this.queryService.listProcessEntity(processRequest);
        PageInfo pageInfo = entityPage.toPageInfo(inst -> WorkflowExecuteLog.builder().processId(inst.getId()).processDisplayName(inst.getDisplayName()).status(inst.getStatus()).startTime(inst.getStartTime()).endTime(inst.getEndTime()).build());
        for (WorkflowExecuteLog executeLog : pageInfo.getList()) {
            TaskRequest taskQuery = new TaskRequest();
            taskQuery.setProcessId(executeLog.getProcessId());
            taskQuery.setType(taskQuery.getType());
            List taskExecuteLogs = this.queryService.listTaskEntity(taskQuery).stream().map(WorkflowUtils::getTaskExecuteLog).collect(Collectors.toList());
            for (TaskExecuteLog taskLog : taskExecuteLogs) {
                EventLogRequest eventLogQuery = new EventLogRequest();
                eventLogQuery.setTaskId(taskLog.getTaskId());
                List logs = this.queryService.listEventLog(eventLogQuery).stream().map(WorkflowUtils::getListenerExecuteLog).collect(Collectors.toList());
                taskLog.setListenerExecuteLogs(logs);
            }
            executeLog.setTaskExecuteLogs(taskExecuteLogs);
        }
        LOGGER.info("success to page list task execute logs for " + query);
        return new PageResult(pageInfo.getList(), Long.valueOf(pageInfo.getTotal()), Integer.valueOf(pageInfo.getPageNum()), Integer.valueOf(pageInfo.getPageSize()));
    }

    private Consumer<ProcessResponse> addCurrentTask(TaskRequest query) {
        return plv -> {
            query.setProcessId(plv.getId());
            plv.setCurrentTasks(this.listTask(query).getList());
        };
    }

    private Map<String, Object> getShowInList(WorkflowProcessEntity processEntity) {
        WorkflowProcess process = this.processDefService.getByName(processEntity.getName());
        if (process == null || process.getFormClass() == null) {
            return null;
        }
        try {
            ProcessForm form = WorkflowUtils.parseProcessForm((ObjectMapper)this.objectMapper, (String)processEntity.getFormData(), (WorkflowProcess)process);
            assert (form != null);
            return form.showInList();
        }
        catch (Exception e) {
            LOGGER.error("get show list err: ", (Throwable)e);
            return null;
        }
    }

    private void addShowInListForEachTask(List<TaskResponse> taskList) {
        if (CollectionUtils.isEmpty(taskList)) {
            return;
        }
        PageHelper.clearPage();
        List list = taskList.stream().map(TaskResponse::getProcessId).distinct().collect(Collectors.toList());
        ProcessRequest query = new ProcessRequest();
        query.setIdList(list);
        List processEntities = this.queryService.listProcessEntity(query);
        HashMap processShowInListMap = Maps.newHashMap();
        processEntities.forEach(entity -> processShowInListMap.put(entity.getId(), this.getShowInList((WorkflowProcessEntity)entity)));
        taskList.forEach(task -> task.setShowInList((Map)processShowInListMap.get(task.getProcessId())));
    }
}

