/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.workflow.consumption;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.inlong.manager.common.enums.ProcessName;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyConsumptionProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.task.ConsumptionApproveForm;
import org.apache.inlong.manager.service.core.WorkflowApproverService;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.apache.inlong.manager.service.listener.consumption.ConsumptionCancelProcessListener;
import org.apache.inlong.manager.service.listener.consumption.ConsumptionCompleteProcessListener;
import org.apache.inlong.manager.service.listener.consumption.ConsumptionPassTaskListener;
import org.apache.inlong.manager.service.listener.consumption.ConsumptionRejectProcessListener;
import org.apache.inlong.manager.service.workflow.WorkflowDefinition;
import org.apache.inlong.manager.service.workflow.consumption.ApplyConsumptionProcessHandler;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.definition.Element;
import org.apache.inlong.manager.workflow.definition.EndEvent;
import org.apache.inlong.manager.workflow.definition.ProcessDetailHandler;
import org.apache.inlong.manager.workflow.definition.StartEvent;
import org.apache.inlong.manager.workflow.definition.UserTask;
import org.apache.inlong.manager.workflow.definition.WorkflowProcess;
import org.apache.inlong.manager.workflow.definition.WorkflowTask;
import org.apache.inlong.manager.workflow.event.process.ProcessEventListener;
import org.apache.inlong.manager.workflow.event.task.TaskEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplyConsumptionWorkflowDefinition
implements WorkflowDefinition {
    @Autowired
    private ConsumptionCompleteProcessListener consumptionCompleteProcessListener;
    @Autowired
    private ConsumptionPassTaskListener consumptionPassTaskListener;
    @Autowired
    private ConsumptionRejectProcessListener consumptionRejectProcessListener;
    @Autowired
    private ConsumptionCancelProcessListener consumptionCancelProcessListener;
    @Autowired
    private WorkflowApproverService workflowApproverService;
    @Autowired
    private ApplyConsumptionProcessHandler applyConsumptionProcessHandler;
    @Autowired
    private InlongGroupService groupService;

    @Override
    public WorkflowProcess defineProcess() {
        WorkflowProcess process = new WorkflowProcess();
        process.setName(this.getProcessName().name());
        process.setType(this.getProcessName().getDisplayName());
        process.setDisplayName(this.getProcessName().getDisplayName());
        process.setFormClass(ApplyConsumptionProcessForm.class);
        process.setVersion(1);
        process.setProcessDetailHandler((ProcessDetailHandler)this.applyConsumptionProcessHandler);
        StartEvent startEvent = new StartEvent();
        process.setStartEvent(startEvent);
        EndEvent endEvent = new EndEvent();
        process.setEndEvent(endEvent);
        UserTask groupOwnerUserTask = new UserTask();
        groupOwnerUserTask.setName("ut_group_owner");
        groupOwnerUserTask.setDisplayName("GroupApproval");
        groupOwnerUserTask.setApproverAssign(this::groupOwnerUserTaskApprover);
        process.addTask((WorkflowTask)groupOwnerUserTask);
        UserTask adminUserTask = new UserTask();
        adminUserTask.setName("ut_admin");
        adminUserTask.setDisplayName("SystemAdmin");
        adminUserTask.setFormClass(ConsumptionApproveForm.class);
        adminUserTask.setApproverAssign(context -> this.getTaskApprovers(adminUserTask.getName()));
        adminUserTask.addListener((TaskEventListener)this.consumptionPassTaskListener);
        process.addTask((WorkflowTask)adminUserTask);
        startEvent.addNext((Element)groupOwnerUserTask);
        groupOwnerUserTask.addNext((Element)adminUserTask);
        adminUserTask.addNext((Element)endEvent);
        process.addListener((ProcessEventListener)this.consumptionCompleteProcessListener);
        process.addListener((ProcessEventListener)this.consumptionRejectProcessListener);
        process.addListener((ProcessEventListener)this.consumptionCancelProcessListener);
        return process;
    }

    private List<String> groupOwnerUserTaskApprover(WorkflowContext context) {
        ApplyConsumptionProcessForm form = (ApplyConsumptionProcessForm)context.getProcessForm();
        InlongGroupInfo groupInfo = this.groupService.get(form.getConsumptionInfo().getInlongGroupId());
        if (groupInfo == null || groupInfo.getInCharges() == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(groupInfo.getInCharges().split(","));
    }

    @Override
    public ProcessName getProcessName() {
        return ProcessName.APPLY_CONSUMPTION_PROCESS;
    }

    private List<String> getTaskApprovers(String taskName) {
        return this.workflowApproverService.getApprovers(this.getProcessName().name(), taskName);
    }
}

