/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.cluster;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongClusterEntity;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.ClusterRequest;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterDTO;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterInfo;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterRequest;
import org.apache.inlong.manager.service.cluster.AbstractClusterOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KafkaClusterOperator
extends AbstractClusterOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaClusterOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String clusterType) {
        return this.getClusterType().equals(clusterType);
    }

    @Override
    public String getClusterType() {
        return "KAFKA";
    }

    @Override
    public ClusterInfo getFromEntity(InlongClusterEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.CLUSTER_NOT_FOUND);
        }
        KafkaClusterInfo kafkaClusterInfo = new KafkaClusterInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)kafkaClusterInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            KafkaClusterDTO dto = KafkaClusterDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)kafkaClusterInfo);
        }
        LOGGER.info("success to get kafka cluster info from entity");
        return kafkaClusterInfo;
    }

    @Override
    protected void setTargetEntity(ClusterRequest request, InlongClusterEntity targetEntity) {
        KafkaClusterRequest kafkaRequest = (KafkaClusterRequest)request;
        CommonBeanUtils.copyProperties((Object)kafkaRequest, (Object)targetEntity, (boolean)true);
        try {
            KafkaClusterDTO dto = KafkaClusterDTO.getFromRequest((KafkaClusterRequest)kafkaRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
            LOGGER.info("success to set entity for kafka cluster");
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }
}

