/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.consume;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.InlongConsumeEntity;
import org.apache.inlong.manager.pojo.consume.InlongConsumeInfo;
import org.apache.inlong.manager.pojo.consume.InlongConsumeRequest;
import org.apache.inlong.manager.pojo.consume.pulsar.ConsumePulsarInfo;
import org.apache.inlong.manager.pojo.consume.tubemq.ConsumeTubeMQDTO;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.tubemq.InlongTubeMQTopicInfo;
import org.apache.inlong.manager.service.consume.AbstractConsumeOperator;
import org.apache.inlong.manager.service.group.InlongGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConsumeTubeMQOperator
extends AbstractConsumeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumeTubeMQOperator.class);
    @Autowired
    private InlongGroupService groupService;

    @Override
    public Boolean accept(String mqType) {
        return this.getMQType().equals(mqType);
    }

    @Override
    public String getMQType() {
        return "TUBEMQ";
    }

    @Override
    public void checkTopicInfo(InlongConsumeRequest request) {
        String groupId = request.getInlongGroupId();
        InlongGroupTopicInfo topicInfo = this.groupService.getTopic(groupId);
        Preconditions.checkNotNull((Object)topicInfo, (String)("inlong group not exist: " + groupId));
        InlongTubeMQTopicInfo tubeMQTopic = (InlongTubeMQTopicInfo)topicInfo;
        Preconditions.checkTrue((boolean)Objects.equals(tubeMQTopic.getTopic(), request.getTopic()), (String)String.format("topic %s for consume not belongs to inlong group %s", request.getTopic(), groupId));
    }

    @Override
    public InlongConsumeInfo getFromEntity(InlongConsumeEntity entity) {
        Preconditions.checkNotNull((Object)entity, (String)ErrorCodeEnum.CONSUME_NOT_FOUND.getMessage());
        ConsumePulsarInfo consumeInfo = new ConsumePulsarInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)consumeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            ConsumeTubeMQDTO dto = ConsumeTubeMQDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)consumeInfo);
        }
        return consumeInfo;
    }

    @Override
    protected void setTargetEntity(InlongConsumeRequest request, InlongConsumeEntity targetEntity) {
        LOGGER.info("do nothing for inlong consume with TubeMQ");
    }
}

