/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamExtEntity;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.kafka.InlongKafkaDTO;
import org.apache.inlong.manager.pojo.group.kafka.InlongKafkaInfo;
import org.apache.inlong.manager.pojo.group.kafka.InlongKafkaRequest;
import org.apache.inlong.manager.pojo.group.kafka.InlongKafkaTopicInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.service.group.AbstractGroupOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InlongGroupOperator4Kafka
extends AbstractGroupOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongGroupOperator4Kafka.class);

    @Override
    public Boolean accept(String mqType) {
        return this.getMQType().equals(mqType);
    }

    @Override
    public String getMQType() {
        return "KAFKA";
    }

    @Override
    public InlongGroupInfo getFromEntity(InlongGroupEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        InlongKafkaInfo kafkaInfo = new InlongKafkaInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)kafkaInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            InlongKafkaDTO dto = InlongKafkaDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)kafkaInfo);
        }
        return kafkaInfo;
    }

    @Override
    protected void setTargetEntity(InlongGroupRequest request, InlongGroupEntity targetEntity) {
        InlongKafkaRequest kafkaRequest = (InlongKafkaRequest)request;
        CommonBeanUtils.copyProperties((Object)kafkaRequest, (Object)targetEntity, (boolean)true);
        try {
            InlongKafkaDTO dto = InlongKafkaDTO.getFromRequest((InlongKafkaRequest)kafkaRequest);
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
        LOGGER.info("success set entity for inlong group with Kafka");
    }

    @Override
    public InlongGroupTopicInfo getTopic(InlongGroupInfo groupInfo) {
        InlongKafkaTopicInfo topicInfo = new InlongKafkaTopicInfo();
        List topics = this.streamService.getTopicList(groupInfo.getInlongGroupId()).stream().map(InlongStreamBriefInfo::getMqResource).collect(Collectors.toList());
        topicInfo.setTopics(topics);
        return topicInfo;
    }

    @Override
    public InlongGroupTopicInfo getBackupTopic(InlongGroupInfo groupInfo) {
        String groupId = groupInfo.getInlongGroupId();
        List<InlongStreamBriefInfo> streamTopics = this.streamService.getTopicList(groupId);
        streamTopics.forEach(stream -> {
            InlongStreamExtEntity streamExtEntity = this.streamExtMapper.selectByKey(groupId, stream.getInlongStreamId(), "backup_mq_resource");
            if (streamExtEntity != null && StringUtils.isNotBlank((CharSequence)streamExtEntity.getKeyValue())) {
                stream.setMqResource(streamExtEntity.getKeyValue());
            }
        });
        InlongKafkaTopicInfo topicInfo = new InlongKafkaTopicInfo();
        List topics = streamTopics.stream().map(InlongStreamBriefInfo::getMqResource).collect(Collectors.toList());
        topicInfo.setTopics(topics);
        return topicInfo;
    }
}

